<?php
require_once __DIR__ . '/../config/database.php';
session_start();

// 1. حماية الصفحات: التأكد من تسجيل الدخول فقط
function protectPage() {
    if (!isset($_SESSION['user_id'])) {
        header("Location: login.php");
        exit();
    }
}

// 2. دالة جلب الصلاحية: تعيد true أو false
function checkPerm($pdo, $page, $action) {
    $role_id = $_SESSION['role_id'] ?? 0;
    $stmt = $pdo->prepare("SELECT $action FROM permissions WHERE role_id = ? AND page_name = ?");
    $stmt->execute([$role_id, $page]);
    return $stmt->fetchColumn() == 1;
}

// 3. دالة التفويض (جديدة): تمنع دخول الصفحة تماماً إذا لم يكن للمستخدم صلاحية
function authorize($pdo, $page, $action = 'can_view') {
    protectPage(); // تأكد أولاً أنه مسجل دخول
    if (!checkPerm($pdo, $page, $action)) {
        // إذا لم يملك الصلاحية، يتم توجيهه لصفحة تنبيه أو منعه
        header("Location: dashboard.php?error=unauthorized");
        exit();
    }
}