<?php
session_start();
if (!isset($_SESSION['logged_in'])) {
    header('Location: login.php');
    exit;
}

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/helpers.php';

/* Permission */
if (!can('users','view')) {
    die('Access Denied');
}

/* Users */
$stmt = $pdo->query("
    SELECT 
        u.user_id,
        u.username,
        u.full_name,
        u.status,
        r.role_name
    FROM users u
    LEFT JOIN roles r ON u.role_id = r.role_id
    ORDER BY u.user_id ASC
");
$users = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Users Management</title>
<link rel="stylesheet" href="../assets/font-awesome/css/all.min.css">

<style>
    @import url('https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap');
    
    body{margin:0;font-family:'Inter', sans-serif;background:#f1f5f9;color:#1e293b}
    .container{padding:25px; max-width: 1200px; margin: auto;}
    
    .header{display:flex;justify-content:space-between;align-items:center;margin-bottom:25px}
    .header h2{margin:0;font-size:22px;font-weight:700;display:flex;align-items:center;gap:10px}

    .btn{padding:8px 16px;border-radius:6px;font-weight:600;text-decoration:none;font-size:13px;display:inline-flex;align-items:center;gap:8px;transition:0.2s}
    .btn-back{background:#fff;color:#475569;border:1px solid #e2e8f0}
    .btn-back:hover{background:#f8fafc}
    .btn-add{background:#1e40af;color:#fff}
    .btn-add:hover{background:#1e3a8a}

    .card{background:#fff;border-radius:12px;box-shadow:0 1px 3px rgba(0,0,0,0.1);border:1px solid #e2e8f0;overflow:hidden}
    table{width:100%;border-collapse:collapse;font-size:14px}
    th,td{padding:14px 16px;border-bottom:1px solid #e2e8f0;text-align:left}
    th{background:#f8fafc;text-transform:uppercase;font-size:12px;font-weight:700;color:#64748b;letter-spacing:0.5px}
    
    tr:last-child td {border-bottom:none}
    tr:hover td {background:#fcfcfc}

    .badge{padding:4px 12px;border-radius:999px;font-size:11px;font-weight:700;text-transform:uppercase}
    .badge-active{background:#dcfce7;color:#15803d}
    .badge-inactive{background:#fee2e2;color:#b91c1c}

    .actions{display:flex;gap:8px;justify-content:center}
    .btn-toggle{background:#f1f5f9;color:#475569;border:1px solid #e2e8f0;padding:6px 12px}
    .btn-toggle:hover{background:#e2e8f0;color:#1e293b}
    .btn-disabled{background:#f8fafc;color:#94a3b8;border:1px solid #e2e8f0;cursor:not-allowed}
</style>
</head>
<body>

<div class="container">

<div class="header">
    <h2><i class="fas fa-users-cog"></i> Users Management</h2>
    <div>
        <a href="dashboard.php" class="btn btn-back">
            <i class="fas fa-arrow-left"></i> Back
        </a>

        <?php if (can('users','add')): ?>
            <a href="user_add.php" class="btn btn-add">
                <i class="fas fa-user-plus"></i> Add User
            </a>
        <?php endif; ?>
    </div>
</div>

<div class="card">
<table>
<thead>
<tr>
    <th width="50">#</th>
    <th>Username</th>
    <th>Full Name</th>
    <th>Role</th>
    <th>Status</th>
    <th style="text-align:center">Actions</th>
</tr>
</thead>
<tbody>

<?php if(!$users): ?>
<tr>
    <td colspan="6" style="text-align:center;padding:40px;color:#94a3b8">
        <i class="fas fa-user-slash" style="font-size:24px;margin-bottom:10px;display:block"></i>
        No users found in the system
    </td>
</tr>
<?php else: foreach($users as $i=>$u): ?>
<tr>
    <td><span style="color:#94a3b8"><?= $i+1 ?></span></td>
    <td style="font-weight:600"><?= htmlspecialchars($u['username'] ?? '') ?></td>
    <td><?= htmlspecialchars($u['full_name'] ?? '') ?></td>
    <td>
        <span style="color:#64748b">
            <i class="fas fa-user-shield" style="font-size:12px"></i> 
            <?= htmlspecialchars($u['role_name'] ?? 'No Role') ?>
        </span>
    </td>
    <td>
        <?php if (($u['status'] ?? '') === 'active'): ?>
            <span class="badge badge-active">Active</span>
        <?php else: ?>
            <span class="badge badge-inactive">Inactive</span>
        <?php endif; ?>
    </td>
    <td>
        <div class="actions">
            <?php if (can('users','delete')): ?>
                <a href="user_toggle.php?id=<?= $u['user_id'] ?>"
                   class="btn btn-toggle"
                   onclick="return confirm('Change user status?')">
                    <i class="fas fa-sync-alt"></i>
                    <?= ($u['status'] ?? '') =='active' ? 'Deactivate' : 'Activate' ?>
                </a>
            <?php else: ?>
                <span class="btn btn-disabled"><i class="fas fa-lock"></i> No Permission</span>
            <?php endif; ?>
        </div>
    </td>
</tr>
<?php endforeach; endif; ?>

</tbody>
</table>
</div>

</div>
</body>
</html>