<style>
    .sidebar {
        display: flex;
        flex-direction: column;
        height: 100vh;
        background: #1e2937;
        width: 260px;
        position: fixed;
        left: 0;
        top: 0;
        z-index: 1050;
    }

    .sidebar-brand {
        padding: 25px 20px;
        background: #111827;
        text-align: center;
        border-bottom: 1px solid rgba(255, 255, 255, 0.05);
    }

    .sidebar-menu-container {
        flex-grow: 1;
        overflow-y: auto;
        padding: 10px 0;
    }

    .menu-item > a {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 12px 20px;
        color: #cbd5e1 !important;
        text-decoration: none;
        transition: all 0.3s;
        font-weight: 500;
    }

    .menu-item > a:hover {
        background: rgba(255, 255, 255, 0.05);
        color: #38bdf8 !important;
    }

    /* أيقونة السهم وحركتها */
    .dropdown-toggle::after {
        border: none;
        font-family: "Font Awesome 5 Free";
        font-weight: 900;
        content: "\f107";
        transition: transform 0.3s ease;
        font-size: 0.8rem;
    }

    .dropdown-toggle[aria-expanded="true"]::after {
        transform: rotate(180deg);
        color: #38bdf8;
    }

    .collapse ul {
        list-style: none;
        padding: 0;
        background: rgba(0, 0, 0, 0.15);
    }

    .collapse ul li a {
        padding: 10px 20px 10px 45px;
        display: block;
        color: #94a3b8 !important;
        text-decoration: none;
        font-size: 0.9rem;
        transition: 0.3s;
    }

    .collapse ul li a:hover {
        color: #38bdf8 !important;
        background: rgba(56, 189, 248, 0.1);
    }

    .logout-section {
        padding: 15px;
        border-top: 1px solid rgba(255, 255, 255, 0.1);
        background: #111827;
    }

    .logout-btn {
        display: flex; align-items: center; gap: 10px; padding: 12px 20px;
        color: #f87171 !important; text-decoration: none; border-radius: 8px;
        font-weight: 600; transition: all 0.3s ease; background: rgba(248, 113, 113, 0.05);
    }

    .logout-btn:hover { background: #ef4444; color: #ffffff !important; }
</style>

<div class="sidebar text-white">
    <div class="sidebar-brand">
        <h2 class="h5 fw-bold mb-0">SHIPPING SYSTEM</h2>
    </div>

    <div class="sidebar-menu-container">
        
        <?php if (can('clients') || can('agents') || can('shipments') || can('price_offers')): ?>
        <div class="menu-item">
            <a href="#opsSub" data-bs-toggle="collapse" class="dropdown-toggle" aria-expanded="false">
                <span><i class="fas fa-exchange-alt me-2"></i> Operations</span>
            </a>
            <div class="collapse" id="opsSub">
                <ul>
                    <?php if (can('clients')): ?> <li><a href="clients.php"><i class="fas fa-users me-2"></i> Clients</a></li> <?php endif; ?>
                    <?php if (can('agents')): ?> <li><a href="agents.php"><i class="fas fa-user-tie me-2"></i> Agents</a></li> <?php endif; ?>
                    <?php if (can('shipments')): ?> <li><a href="shipments.php"><i class="fas fa-box me-2"></i> Shipments</a></li> <?php endif; ?>
                    <?php if (can('price_offers')): ?> <li><a href="price_offers.php"><i class="fas fa-file-invoice-dollar me-2"></i> Price Offers</a></li> <?php endif; ?>
                  <?php if (can('hubs')): ?> <li><a href="hubs.php"><i class="fas fa-file-invoice-dollar me-2"></i> hubs</a></li> <?php endif; ?>
                  <?php if (can('line')): ?> <li><a href="Line.php"><i class="fas fa-file-invoice-dollar me-2"></i> Line</a></li> <?php endif; ?>
                <?php if (can('container')): ?> <li><a href="container.php"><i class="fas fa-file-invoice-dollar me-2"></i> container</a></li> <?php endif; ?>
                <?php if (can('bank')): ?> <li><a href="bank.php"><i class="fas fa-file-invoice-dollar me-2"></i> bank</a></li> <?php endif; ?>
                                
                    </ul>
            </div>
        </div>
        <?php endif; ?>

        <?php if (can('receive') || can('pay') || can('safes') || can('currencies')): ?>
        <div class="menu-item">
            <a href="#accSub" data-bs-toggle="collapse" class="dropdown-toggle" aria-expanded="false">
                <span><i class="fas fa-wallet me-2"></i> Accounts</span>
            </a>
            <div class="collapse" id="accSub">
                <ul>
                    <?php if (can('receive')): ?> <li><a href="receive.php"><i class="fas fa-file-import me-2"></i> Receipt Voucher</a></li> <?php endif; ?>
                    <?php if (can('pay')): ?> <li><a href="pay.php"><i class="fas fa-file-export me-2"></i> Payment Voucher</a></li> <?php endif; ?>
                    <?php if (can('safes')): ?> <li><a href="safes.php"><i class="fas fa-vault me-2"></i> Cash Boxes</a></li> <?php endif; ?>
                    <?php if (can('currencies')): ?> <li><a href="currencies.php"><i class="fas fa-coins me-2"></i> Currencies</a></li> <?php endif; ?>
                </ul>
            </div>
        </div>
        <?php endif; ?>

        <?php if (can('agent_transactions') || can('customer_transactions') || can('daily_transactions')): ?>
        <div class="menu-item">
            <a href="#detSub" data-bs-toggle="collapse" class="dropdown-toggle" aria-expanded="false">
                <span><i class="fas fa-chart-line me-2"></i> Details</span>
            </a>
            <div class="collapse" id="detSub">
                <ul>
                    <?php if (can('agent_transactions')): ?> <li><a href="agent_transactions.php"><i class="fas fa-list me-2"></i> Agent Ledger</a></li> <?php endif; ?>
                    <?php if (can('customer_transactions')): ?> <li><a href="customer_transactions.php"><i class="fas fa-list me-2"></i> Customer Ledger</a></li> <?php endif; ?>
                                            <?php if (can('daily_transactions')): ?> <li><a href="daily_transactions.php"><i class="fas fa-history me-2"></i> Daily Journal</a></li> <?php endif; ?>
                                                           <?php if (can('expenses')): ?> <li><a href="expenses.php"><i class="fas fa-history me-2"></i> expenses</a></li> <?php endif; ?>

                                            </ul>
            </div>
        </div>
        <?php endif; ?>

        <div class="menu-item">
            <a href="#setSub" data-bs-toggle="collapse" class="dropdown-toggle" aria-expanded="false">
                <span><i class="fas fa-cog me-2"></i> Settings</span>
            </a>
            <div class="collapse" id="setSub">
                <ul>
                    <li><a href="profile.php"><i class="fas fa-user-circle me-2"></i> Profile</a></li>
                    <?php if (can('users')): ?> <li><a href="users.php"><i class="fas fa-users-cog me-2"></i> Users</a></li> <?php endif; ?>
                  
                     <?php if (can('permissions')): ?> <li><a href="permissions.php"><i class="fas fa-shield-alt me-2"></i> permissions</a></li> <?php endif; ?>
                
                        <?php if (can('roles')): ?> <li><a href="roles.php"><i class="fas fa-shield-alt me-2"></i> Roles</a></li> <?php endif; ?>
                    <?php if (can('company_settings')): ?> <li><a href="company_settings.php"><i class="fas fa-building me-2"></i> Company Info</a></li> <?php endif; ?>
                </ul>
            </div>
        </div>

        <?php if (can('export') || can('restore')): ?>
<div class="menu-item">
    <a href="#dbSub" data-bs-toggle="collapse" class="dropdown-toggle" aria-expanded="false">
        <span><i class="fas fa-database me-2"></i> Database</span>
    </a>
    <div class="collapse" id="dbSub">
        <ul>
            <?php if (can('export')): ?> 
                <li><a href="export.php"><i class="fas fa-file-export me-2"></i> Export Data</a></li> 
            <?php endif; ?>

            <?php if (can('restore')): ?> 
                <li><a href="restore.php"><i class="fas fa-sync-alt me-2"></i> Restore Data</a></li> 
            <?php endif; ?>
        </ul>
    </div>
</div>
<?php endif; ?>

    </div>

    <div class="logout-section">
        <a href="logout.php" class="logout-btn">
            <i class="fas fa-power-off"></i> <span>Logout</span>
        </a>
    </div>
</div>

<script>
document.addEventListener("DOMContentLoaded", function() {
    const currentLocation = window.location.pathname.split("/").pop();
    const allSubLinks = document.querySelectorAll(".collapse ul li a");
    
    allSubLinks.forEach(link => {
        if(link.getAttribute("href") === currentLocation) {
            // تلوين الرابط النشط
            link.style.color = "#38bdf8"; 
            link.style.fontWeight = "bold";
            link.style.background = "rgba(56, 189, 248, 0.1)";
            
            // فتح القائمة الأب
            const parentCollapse = link.closest(".collapse");
            if(parentCollapse) {
                const bsCollapse = new bootstrap.Collapse(parentCollapse, { toggle: false });
                bsCollapse.show();
                
                // تحديث حالة السهم
                const toggler = document.querySelector(`[href="#${parentCollapse.id}"]`);
                if(toggler) {
                    toggler.setAttribute('aria-expanded', 'true');
                    toggler.classList.remove('collapsed');
                }
            }
        }
    });
});
</script>