<?php
require_once '../src/auth.php';
protectPage();

// 1. التحقق من وجود ID الشحنة
if (!isset($_GET['id']) || empty($_GET['id'])) {
    header("Location: shipments_list.php");
    exit();
}

$shipment_id = $_GET['id'];

// 2. جلب كافة تفاصيل الشحنة مع أسماء العميل والوكيل والعملة
try {
    $query = "SELECT s.*, 
                     c.name as customer_name, c.phone as customer_phone, c.email as customer_email,
                     a.name as agent_name, a.country as agent_country, a.phone as agent_phone,
                     curr.currency_name, curr.currency_code
              FROM shipments s
              INNER JOIN customers c ON s.customer_id = c.customer_id
              INNER JOIN agents a ON s.agent_id = a.agent_id
              LEFT JOIN currencies curr ON s.currency_id = curr.currency_id
              WHERE s.shipment_id = ?";
    
    $stmt = $pdo->prepare($query);
    $stmt->execute([$shipment_id]);
    $s = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$s) { die("الشحنة غير موجودة!"); }
} catch (PDOException $e) {
    die("خطأ في قاعدة البيانات: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>تفاصيل الشحنة #<?= $shipment_id ?></title>
    <link rel="stylesheet" href="../assets/font-awesome/css/all.min.css">
    <style>
        :root { --primary: #2c3e50; --accent: #3498db; --success: #27ae60; --warning: #f39c12; }
        body { font-family: 'Segoe UI', sans-serif; background: #f4f7f6; margin: 0; display: flex; }
        .sidebar { width: 260px; background: var(--primary); height: 100vh; position: fixed; right: 0; color: white; }
        .main-content { margin-right: 260px; flex: 1; padding: 30px; width: calc(100% - 260px); }
        
        .details-grid { display: grid; grid-template-columns: repeat(2, 1fr); gap: 20px; }
        .info-card { background: white; padding: 20px; border-radius: 12px; box-shadow: 0 2px 10px rgba(0,0,0,0.05); border-top: 4px solid var(--accent); }
        .info-card.financial { border-top-color: var(--success); }
        .info-card.status { border-top-color: var(--warning); }
        
        .card-title { font-size: 1.1rem; font-weight: bold; margin-bottom: 15px; color: var(--primary); border-bottom: 1px solid #eee; padding-bottom: 10px; display: flex; align-items: center; gap: 10px; }
        .data-row { display: flex; justify-content: space-between; padding: 8px 0; border-bottom: 1px dashed #f0f0f0; }
        .label { color: #7f8c8d; font-weight: 600; }
        .value { color: #2c3e50; font-weight: bold; }

        .status-badge { padding: 5px 15px; border-radius: 20px; font-size: 0.9rem; }
        .status-pending { background: #fff3cd; color: #856404; }
        .status-shipped { background: #d1ecf1; color: #0c5460; }
        .status-arrived { background: #d4edda; color: #155724; }

        .action-bar { background: white; padding: 15px 25px; border-radius: 10px; margin-bottom: 20px; display: flex; justify-content: space-between; align-items: center; }
        .btn { padding: 10px 20px; border-radius: 6px; text-decoration: none; font-weight: bold; cursor: pointer; border: none; }
        .btn-print { background: #95a5a6; color: white; }
        .btn-edit { background: var(--warning); color: white; }

        @media print {
            .sidebar, .action-bar { display: none; }
            .main-content { margin: 0; width: 100%; padding: 0; }
            .info-card { box-shadow: none; border: 1px solid #ddd; }
        }
    </style>
</head>
<body>

    <div class="sidebar">
        <div style="padding: 20px; text-align: center; background: #1a252f;">نظام الملاحة</div>
        <a href="shipments_list.php" style="display:block; padding:15px; color:white; text-decoration:none;"><i class="fas fa-arrow-right"></i> عودة للقائمة</a>
    </div>

    <div class="main-content">
        <div class="action-bar">
            <h2 style="margin:0;">ملف الشحنة رقم #<?= $s['shipment_id'] ?></h2>
            <div>
                <button onclick="window.print()" class="btn btn-print"><i class="fas fa-print"></i> طباعة التفاصيل</button>
                <a href="shipment_edit.php?id=<?= $s['shipment_id'] ?>" class="btn btn-edit"><i class="fas fa-edit"></i> تعديل البيانات</a>
            </div>
        </div>

        <div class="details-grid">
            <div class="info-card">
                <div class="card-title"><i class="fas fa-users"></i> الأطراف المعنية</div>
                <div class="data-row"><span class="label">العميل:</span> <span class="value"><?= $s['customer_name'] ?></span></div>
                <div class="data-row"><span class="label">هاتف العميل:</span> <span class="value"><?= $s['customer_phone'] ?></span></div>
                <div class="data-row"><span class="label">الوكيل:</span> <span class="value"><?= $s['agent_name'] ?> (<?= $s['agent_country'] ?>)</span></div>
                <div class="data-row"><span class="label">هاتف الوكيل:</span> <span class="value"><?= $s['agent_phone'] ?></span></div>
            </div>

            <div class="info-card status">
                <div class="card-title"><i class="fas fa-truck-ramp-box"></i> المسار والحالة</div>
                <div class="data-row">
                    <span class="label">الحالة الحالية:</span> 
                    <span class="status-badge status-<?= $s['shipping_status'] ?>"><?= $s['shipping_status'] ?></span>
                </div>
                <div class="data-row"><span class="label">تاريخ الطلب:</span> <span class="value"><?= $s['order_date'] ?></span></div>
                <div class="data-row"><span class="label">الوصول المتوقع:</span> <span class="value"><?= $s['expected_arrival_date'] ?></span></div>
                <div class="data-row"><span class="label">آخر تحديث:</span> <span class="value"><?= date('Y-m-d H:i', strtotime($s['updated_at'])) ?></span></div>
            </div>

            <div class="info-card" style="grid-column: span 2;">
                <div class="card-title"><i class="fas fa-box-open"></i> محتويات الشحنة واللوجستيات</div>
                <div class="data-row"><span class="label">وصف البضاعة:</span> <span class="value"><?= nl2br(htmlspecialchars($s['item_description'])) ?></span></div>
                <div class="data-row">
                    <span class="label">تخليص جمركي:</span> 
                    <span class="value"><?= $s['needs_customs'] ? '<i class="fas fa-check-circle" style="color:var(--success)"></i> مطلوب' : 'غير مطلوب' ?></span>
                </div>
                <div class="data-row">
                    <span class="label">توصيل للموقع:</span> 
                    <span class="value"><?= $s['needs_delivery_to_site'] ? '<i class="fas fa-truck" style="color:var(--accent)"></i> مطلوب' : 'استلام من المخزن' ?></span>
                </div>
                <?php if($s['needs_delivery_to_site']): ?>
                <div class="data-row"><span class="label">عنوان التوصيل:</span> <span class="value"><?= htmlspecialchars($s['delivery_address']) ?></span></div>
                <?php endif; ?>
            </div>

            <div class="info-card financial" style="grid-column: span 2;">
                <div class="card-title"><i class="fas fa-file-invoice-dollar"></i> الملخص المالي (العملة: <?= $s['currency_name'] ?>)</div>
                <div style="display: flex; gap: 50px; justify-content: space-around; padding: 10px 0;">
                    <div style="text-align: center;">
                        <div class="label">السعر على العميل</div>
                        <div class="value" style="font-size: 1.5rem; color: var(--success);"><?= number_format($s['customer_total_price'], 2) ?> <small><?= $s['currency_code'] ?></small></div>
                    </div>
                    <div style="text-align: center;">
                        <div class="label">تكلفة الوكيل</div>
                        <div class="value" style="font-size: 1.5rem; color: #e74c3c;"><?= number_format($s['agent_total_cost'], 2) ?> <small><?= $s['currency_code'] ?></small></div>
                    </div>
                    <div style="text-align: center;">
                        <div class="label">رسوم الجمارك</div>
                        <div class="value" style="font-size: 1.5rem; color: #34495e;"><?= number_format($s['customs_fees'], 2) ?> <small><?= $s['currency_code'] ?></small></div>
                    </div>
                    <div style="text-align: center; border-right: 2px solid #eee; padding-right: 50px;">
                        <div class="label">صافي الربح التقديري</div>
                        <?php $profit = $s['customer_total_price'] - $s['agent_total_cost'] - $s['customs_fees']; ?>
                        <div class="value" style="font-size: 1.5rem; color: var(--accent);"><?= number_format($profit, 2) ?> <small><?= $s['currency_code'] ?></small></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</body>
</html>