<?php
require_once '../src/auth.php';
protectPage();

/* ======================
   Fetch Safes
====================== */
$stmt = $pdo->prepare("
    SELECT 
        cashbox_id,
        cashbox_name,
        cashbox_code,
        currency_id,
        opening_balance,
        current_balance,
        status,
        notes,
        created_at,
        updated_at
    FROM cash_boxes
    ORDER BY cashbox_id DESC
");
$stmt->execute();
$safes = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Safes Management</title>
<link rel="stylesheet" href="../assets/font-awesome/css/all.min.css">

<style>
:root{
    --bg:#f1f5f9;
    --card:#ffffff;
    --border:#e5e7eb;
    --text:#1f2937;
    --muted:#6b7280;
    --primary:#2563eb;
    --success:#16a34a;
    --danger:#dc2626;
    --shadow:0 10px 25px rgba(0,0,0,.06);
}
*{box-sizing:border-box}
body{
    margin:0;
    font-family:'Inter','Segoe UI',Arial,sans-serif;
    background:var(--bg);
    color:var(--text);
}
.container{ padding:28px; }
.page-header{
    display:flex;
    justify-content:space-between;
    align-items:center;
    margin-bottom:22px;
}
.page-header h2{
    margin:0;
    font-size:1.2rem;
    font-weight:800;
}
.btn{
    padding:8px 12px;
    border-radius:8px;
    font-size:12px;
    font-weight:700;
    text-decoration:none;
    border:none;
    cursor:pointer;
    display:inline-flex;
    align-items:center;
    gap:6px;
}
.btn-gray{background:#334155;color:#fff}
.btn-success{background:#16a34a;color:#fff}
.btn-primary{background:#2563eb;color:#fff}
.btn-danger{background:#dc2626;color:#fff}
.card{
    background:var(--card);
    border-radius:14px;
    box-shadow:var(--shadow);
    border:1px solid var(--border);
    overflow:hidden;
}
table{ width:100%; border-collapse:collapse; }
thead{ background:#f8fafc; }
th,td{
    padding:12px 14px;
    font-size:13px;
    border-bottom:1px solid var(--border);
    white-space:nowrap;
}
th{
    text-align:left;
    color:#374151;
    font-weight:800;
    font-size:12px;
    text-transform:uppercase;
}
.badge{
    padding:4px 10px;
    border-radius:999px;
    font-size:11px;
    font-weight:800;
}
.badge-active{ background:#dcfce7; color:#166534; }
.badge-inactive{ background:#fee2e2; color:#991b1b; }
.actions{
    display:flex;
    gap:6px;
    justify-content:center;
}
</style>
</head>
<body>

<div class="container">

   <div class="page-header">
    <h2>💰 box Management</h2>
    <div>
        <a href="dashboard.php" class="btn btn-gray">
            <i class="fas fa-arrow-left"></i> Back
        </a>

        <a href="transfer_money.php" class="btn btn-primary">
            <i class="fas fa-exchange-alt"></i> Transfer & Exchange
        </a>

        <a href="transfer_log.php" class="btn btn-gray">
            <i class="fas fa-history"></i> Exchange Log
        </a>

       
    </div>
</div>

    <div class="card">
        <table>
            <thead>
                <tr>
                    <th>#</th>
                    <th>Safe Name</th>
                    <th>Code</th>
                    <th>Opening</th>
                    <th>Current</th>
                    <th>Status</th>
                    <th>Created</th>
                    <th style="text-align:center;">Actions</th>
                </tr>
            </thead>
            <tbody>
            <?php if (!$safes): ?>
                <tr>
                    <td colspan="8" style="text-align:center;color:#6b7280;padding:40px;">
                        No safes found
                    </td>
                </tr>
            <?php else: ?>
                <?php foreach ($safes as $i => $s): ?>
                <tr>
                    <td><?= $i + 1 ?></td>
                    <td><?= htmlspecialchars($s['cashbox_name']) ?></td>
                    <td><?= htmlspecialchars($s['cashbox_code']) ?></td>
                    <td><?= number_format($s['opening_balance'],2) ?></td>
                    <td><?= number_format($s['current_balance'],2) ?></td>
                    <td>
                        <?php if ($s['status'] === 'active'): ?>
                            <span class="badge badge-active">Active</span>
                        <?php else: ?>
                            <span class="badge badge-inactive">Inactive</span>
                        <?php endif; ?>
                    </td>
                    <td><?= htmlspecialchars($s['created_at']) ?></td>
                    <td>
                        <div class="actions">
                            <a href="safe_edit.php?id=<?= $s['cashbox_id'] ?>" class="btn btn-primary">
                                <i class="fas fa-edit"></i>
                            </a>
                            <a href="safe_toggle.php?id=<?= $s['cashbox_id'] ?>"
                               class="btn btn-danger"
                               onclick="return confirm('Change safe status?')">
                                <i class="fas fa-ban"></i>
                            </a>
                        </div>
                    </td>
                </tr>
                <?php endforeach; ?>
            <?php endif; ?>
            </tbody>
        </table>
    </div>

</div>

</body>
</html>
