<?php
require_once '../src/auth.php';
protectPage();

if (!isset($_GET['id'])) {
    header("Location: safes.php");
    exit;
}

$cashbox_id = (int)$_GET['id'];

/* ======================
   Get Current Status
====================== */
$stmt = $pdo->prepare("
    SELECT status 
    FROM cash_boxes 
    WHERE cashbox_id = ?
    LIMIT 1
");
$stmt->execute([$cashbox_id]);
$safe = $stmt->fetch();

if (!$safe) {
    header("Location: safes.php");
    exit;
}

/* ======================
   Toggle Status
====================== */
$new_status = ($safe['status'] === 'active') ? 'inactive' : 'active';

$stmt = $pdo->prepare("
    UPDATE cash_boxes
    SET status = ?, updated_at = NOW()
    WHERE cashbox_id = ?
");
$stmt->execute([$new_status, $cashbox_id]);

/* ======================
   Redirect Back
====================== */
header("Location: safes.php?status_changed=1");
exit;
