<?php
require_once '../src/auth.php';
protectPage();

$message = "";

/* ======================
   Fetch Currencies
====================== */
$stmt = $pdo->prepare("SELECT currency_id, currency_name, currency_code FROM currencies ORDER BY currency_name");
$stmt->execute();
$currencies = $stmt->fetchAll();

/* ======================
   Handle Form Submit
====================== */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $name   = trim($_POST['cashbox_name']);
    $code   = trim($_POST['cashbox_code']);
    $currency_id = (int)$_POST['currency_id'];
    $opening = (float)$_POST['opening_balance'];
    $notes  = trim($_POST['notes']);
    $status = isset($_POST['status']) ? 'active' : 'inactive';

    try {
        $stmt = $pdo->prepare("
            INSERT INTO cash_boxes
            (cashbox_name, cashbox_code, currency_id, opening_balance, current_balance, status, notes, created_at)
            VALUES (?, ?, ?, ?, ?, ?, ?, NOW())
        ");
        $stmt->execute([
            $name,
            $code,
            $currency_id,
            $opening,
            $opening,
            $status,
            $notes
        ]);

        header("Location: safes.php?added=1");
        exit;

    } catch (PDOException $e) {
        $message = "<div class='alert danger'>Error: ".$e->getMessage()."</div>";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Add Safe</title>
<link rel="stylesheet" href="../assets/font-awesome/css/all.min.css">

<style>
body{
    margin:0;
    font-family:'Segoe UI',Arial,sans-serif;
    background:#f1f5f9;
}
.container{
    max-width:700px;
    margin:40px auto;
    background:#fff;
    padding:30px;
    border-radius:12px;
    box-shadow:0 10px 25px rgba(0,0,0,.08);
}
h2{
    margin-top:0;
    font-size:1.3rem;
}
.form-group{
    margin-bottom:15px;
}
label{
    display:block;
    font-weight:700;
    margin-bottom:6px;
}
input, select, textarea{
    width:100%;
    padding:10px;
    border-radius:8px;
    border:1px solid #d1d5db;
    font-size:14px;
}
textarea{ resize:vertical; }
.actions{
    margin-top:20px;
    display:flex;
    gap:10px;
}
.btn{
    padding:10px 16px;
    border-radius:8px;
    border:none;
    cursor:pointer;
    font-weight:700;
    text-decoration:none;
    display:inline-flex;
    align-items:center;
    gap:6px;
}
.btn-save{ background:#16a34a; color:#fff; }
.btn-back{ background:#6b7280; color:#fff; }
.switch{
    display:flex;
    align-items:center;
    gap:10px;
}
.alert{
    padding:12px;
    border-radius:8px;
    margin-bottom:15px;
}
.alert.danger{
    background:#fee2e2;
    color:#991b1b;
}
</style>
</head>
<body>

<div class="container">

    <h2><i class="fas fa-cash-register"></i> Add New Safe</h2>

    <?= $message ?>

    <form method="POST">

        <div class="form-group">
            <label>Safe Name</label>
            <input type="text" name="cashbox_name" required>
        </div>

        <div class="form-group">
            <label>Safe Code</label>
            <input type="text" name="cashbox_code">
        </div>

        <div class="form-group">
            <label>Currency</label>
            <select name="currency_id" required>
                <option value="">-- Select Currency --</option>
                <?php foreach ($currencies as $c): ?>
                    <option value="<?= $c['currency_id'] ?>">
                        <?= htmlspecialchars($c['currency_name'].' ('.$c['currency_code'].')') ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="form-group">
            <label>Opening Balance</label>
            <input type="number" step="0.01" name="opening_balance" value="0">
        </div>

        <div class="form-group">
            <label>Notes</label>
            <textarea name="notes" rows="3"></textarea>
        </div>

        <div class="form-group switch">
            <label>
                <input type="checkbox" name="status" checked>
                Active
            </label>
        </div>

        <div class="actions">
            <button type="submit" class="btn btn-save">
                <i class="fas fa-save"></i> Save
            </button>
            <a href="safes.php" class="btn btn-back">
                Cancel
            </a>
        </div>

    </form>

</div>

</body>
</html>
