<?php
session_start();
if (!isset($_SESSION['logged_in'])) {
    header('Location: login.php');
    exit;
}

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/helpers.php';

// التحقق من الصلاحيات
if (!can('restore', 'add')) {
    die('Access Denied: You do not have permission to import database.');
}

$message = "";

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_FILES['backup_file'])) {
    try {
        $file = $_FILES['backup_file'];
        
        // التأكد من امتداد الملف
        $ext = pathinfo($file['name'], PATHINFO_EXTENSION);
        if ($ext !== 'sql') {
            throw new Exception("الرجاء اختيار ملف بصيغة .sql فقط");
        }

        // قراءة محتوى الملف
        $sql = file_get_contents($file['tmp_name']);
        
        if (empty($sql)) {
            throw new Exception("الملف المرفوع فارغ!");
        }

        // إيقاف التحقق من القيود لتجنب الأخطاء أثناء البناء
        $pdo->exec("SET FOREIGN_KEY_CHECKS=0;");

        // تنفيذ الاستعلامات
        // ملاحظة: هذه الطريقة للملفات المتوسطة، للملفات الضخمة يفضل استخدام exec مباشرة
        $pdo->exec($sql);

        $pdo->exec("SET FOREIGN_KEY_CHECKS=1;");

        $message = "<div class='alert alert-success'>تم استيراد قاعدة البيانات بنجاح!</div>";
        
    } catch (Exception $e) {
        $message = "<div class='alert alert-danger'>خطأ أثناء الاستيراد: " . $e->getMessage() . "</div>";
    }
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>استيراد قاعدة البيانات</title>
    <link href="../assets/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../assets/font-awesome/css/all.min.css">
    <style>
        body { background-color: #f8f9fa; }
        .import-card { max-width: 600px; margin: 50px auto; border-radius: 15px; box-shadow: 0 4px 15px rgba(0,0,0,0.1); }
        .card-header { background: #4f46e5; color: white; border-radius: 15px 15px 0 0 !important; }
        .file-upload-wrapper { border: 2px dashed #d1d5db; padding: 30px; text-align: center; border-radius: 10px; cursor: pointer; transition: 0.3s; }
        .file-upload-wrapper:hover { border-color: #4f46e5; background: #f5f3ff; }
    </style>
</head>
<body>

<div class="container">
     <a href="dashboard.php" class="btn btn-gray">
                <i class="fas fa-arrow-left"></i> Back
            </a>
    <div class="card import-card">
        <div class="card-header p-4">
            <h5 class="mb-0"><i class="fas fa-file-import me-2"></i> استيراد نسخة احتياطية (.sql)</h5>
        </div>
        <div class="card-body p-4">
            <?= $message ?>
            
            <p class="text-muted small">
                <i class="fas fa-exclamation-triangle text-warning"></i> 
                تنبيه: استيراد قاعدة بيانات سيقوم بحذف الجداول الحالية واستبدالها بالبيانات الموجودة في الملف.
            </p>

            <form method="POST" enctype="multipart/form-data">
                <div class="mb-4">
                    <label class="form-label fw-bold">اختر ملف النسخة الاحتياطية:</label>
                    <div class="file-upload-wrapper" onclick="document.getElementById('backup_file').click();">
                        <i class="fas fa-cloud-upload-alt fa-3x text-muted mb-3"></i>
                        <p class="mb-0 text-muted">اضغط هنا لاختيار الملف أو اسحبه هنا</p>
                        <input type="file" name="backup_file" id="backup_file" hidden required accept=".sql">
                    </div>
                    <div id="file_name_display" class="mt-2 text-primary fw-bold text-center"></div>
                </div>

                <div class="d-grid">
                    <button type="submit" class="btn btn-primary btn-lg py-3">
                        <i class="fas fa-upload me-2"></i> بدء عملية الاستيراد الآن
                    </button>
                </div>
            </form>
            
            <div class="mt-4 text-center">
                <a href="export.php" class="btn btn-link btn-sm text-decoration-none text-muted">
                    <i class="fas fa-download me-1"></i> هل تريد تصدير نسخة أولاً؟
                </a>
            </div>
        </div>
    </div>
</div>

<script>
    // لعرض اسم الملف المختار للمستخدم
    document.getElementById('backup_file').onchange = function() {
        if(this.files[0]) {
            document.getElementById('file_name_display').innerHTML = 
                "<i class='fas fa-file-code'></i> " + this.files[0].name;
        }
    };
</script>

</body>
</html>