<?php
session_start();
if (!isset($_SESSION['logged_in'])) {
    header('Location: login.php');
    exit;
}

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/helpers.php';

if (!can('receive','view') && !can('receive','print')) {
    die('Access Denied');
}

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) die('Invalid ID');

$conf = $pdo->query("SELECT * FROM company_settings LIMIT 1")->fetch();

$stmt = $pdo->prepare("
    SELECT v.*, c.name customer_name, cb.cashbox_name
    FROM receipt_vouchers v
    LEFT JOIN customers c ON v.customer_id=c.customer_id
    LEFT JOIN cash_boxes cb ON v.cashbox_id=cb.cashbox_id
    WHERE v.receipt_id=?
");
$stmt->execute([$id]);
$v = $stmt->fetch();
if (!$v) die('Not Found');

// التحقق مما إذا كان السند ملغياً (نفس منطق سند الصرف)
$is_inactive = (isset($v['status']) && strtolower($v['status']) === 'inactive');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Receipt Voucher #<?= $id ?></title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Cairo:wght@400;700&family=Inter:wght@400;700;800&display=swap');

        body {
            background: #f1f5f9;
            font-family: 'Inter', 'Cairo', sans-serif;
            margin: 0;
            padding: 0;
            color: #1e293b;
        }

        .voucher-paper {
            width: 210mm;
            min-height: 297mm;
            background: #fff;
            margin: 20px auto;
            padding: 12mm;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
            position: relative;
            box-sizing: border-box;
            overflow: hidden; /* ضروري لقص العلامة المائية الزائدة */
        }

        /* ===== العلامة المائية للسند الملغي ===== */
        .cancelled-watermark {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) rotate(-45deg);
            font-size: 150px;
            color: rgba(220, 38, 38, 0.1);
            font-weight: 900;
            border: 20px solid rgba(220, 38, 38, 0.1);
            padding: 20px 60px;
            z-index: 10;
            pointer-events: none;
            text-transform: uppercase;
        }

        /* ===== الهيدر ===== */
        .main-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            border-bottom: 3px double #1e293b;
            padding-bottom: 15px;
            margin-bottom: 30px;
        }

        .header-content-en { width: 38%; text-align: left; font-size: 13px; line-height: 1.5; }
        .header-content-en h1 { margin: 0 0 5px 0; font-size: 18px; color: #0f172a; font-weight: 800; }

        .header-logo { width: 20%; text-align: center; }
        .header-logo img { max-width: 120px; height: auto; }

        .header-content-ar { width: 38%; text-align: right; direction: rtl; font-size: 14px; line-height: 1.6; }
        .header-content-ar h1 { margin: 0 0 5px 0; font-size: 20px; color: #0f172a; font-weight: 700; }

        /* ===== المحتوى ===== */
        .voucher-body { padding: 0 10px; }

        .title-box {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 40px;
        }
        .title-text {
            font-size: 26px;
            font-weight: 800;
            text-transform: uppercase;
            border-left: 8px solid #1e293b;
            padding-left: 15px;
            letter-spacing: 1px;
        }
        .meta-data { text-align: right; font-weight: 600; }

        .details-table { width: 100%; border-collapse: separate; border-spacing: 0 15px; }
        .details-table td { padding: 15px; vertical-align: middle; }
        .label-cell { width: 160px; font-size: 12px; font-weight: 700; color: #64748b; text-transform: uppercase; }
        .value-cell { background: #f8fafc; font-size: 16px; font-weight: 600; border-bottom: 1px solid #e2e8f0; }
        
        .amount-highlight { background: #f0fdf4 !important; border: 1px solid #dcfce7 !important; }
        .amount-text { font-size: 32px !important; font-weight: 800; color: #15803d; font-family: 'Courier New', monospace; }

        /* التوقيعات */
        .signature-section { display: flex; justify-content: space-around; margin-top: 80px; }
        .sig-item { width: 250px; text-align: center; }
        .sig-line { border-top: 2px solid #1e293b; margin-bottom: 10px; }
        .sig-label { font-weight: 800; font-size: 13px; text-transform: uppercase; }

        .footer-address { position: absolute; bottom: 15mm; left: 0; right: 0; text-align: center; font-size: 11px; color: #94a3b8; border-top: 1px solid #f1f5f9; padding-top: 15px; }

        .no-print { text-align: center; padding: 20px; background: #0f172a; }
        .btn { padding: 12px 35px; border-radius: 8px; border: none; font-weight: 700; cursor: pointer; margin: 0 5px; transition: 0.3s; }
        .btn-print { background: #10b981; color: white; }
        .btn-back { background: #475569; color: white; }

        @media print {
            body { background: white; }
            .no-print { display: none; }
            .voucher-paper { margin: 0; box-shadow: none; width: 100%; }
        }
    </style>
</head>
<body>

    <div class="no-print">
        <button class="btn btn-print" onclick="window.print()">طباعة السند / PRINT</button>
        <button class="btn btn-back" onclick="history.back()">رجوع / BACK</button>
    </div>

    <div class="voucher-paper">
        <?php if ($is_inactive): ?>
            <div class="cancelled-watermark">VOID</div>
        <?php endif; ?>
        
        <header class="main-header">
            <div class="header-content-en">
                <h1><?= htmlspecialchars($conf['company_name_en']) ?></h1>
                <div>For Customs Clearance & Shipping</div>
                <div><?= htmlspecialchars($conf['address_en']) ?></div>
                <div><strong>Tel:</strong> <?= htmlspecialchars($conf['phones_en']) ?></div>
            </div>

            <div class="header-logo">
                <?php if($conf['logo_path']): ?>
                    <img src="../assets/img/<?= htmlspecialchars($conf['logo_path']) ?>" alt="Logo">
                <?php endif; ?>
            </div>

            <div class="header-content-ar">
                <h1><?= htmlspecialchars($conf['company_name_ar']) ?></h1>
                <div>للتخليص الجمركي والشحن ونقل البضائع</div>
                <div><?= htmlspecialchars($conf['address_ar']) ?></div>
                <div><strong>هاتف:</strong> <?= htmlspecialchars($conf['phones_ar']) ?></div>
            </div>
        </header>

        <div class="voucher-body">
            <div class="title-box">
                <div class="title-text" style="<?= $is_inactive ? 'color:#991b1b; border-left-color:#991b1b;' : '' ?>">
                    <?= $is_inactive ? 'CANCELLED RECEIPT' : 'Receipt Voucher' ?>
                </div>
                <div class="meta-data">
                    <div style="font-size: 18px;">No: #<?= $id ?></div>
                    <div style="color: #64748b;">Date: <?= date('d M Y', strtotime($v['voucher_date'])) ?></div>
                </div>
            </div>

            <table class="details-table">
                <tr>
                    <td class="label-cell">Received From</td>
                    <td class="value-cell" colspan="3"><?= htmlspecialchars($v['customer_name']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">Total Amount</td>
                    <td class="value-cell amount-highlight" colspan="3">
                        <span style="font-size: 14px; vertical-align: middle;">USD</span>
                        <span class="amount-text"><?= number_format($v['amount'], 2) ?></span>
                    </td>
                </tr>
                <tr>
                    <td class="label-cell">Payment Mode</td>
                    <td class="value-cell" style="width: 30%;"><?= htmlspecialchars($v['payment_method']) ?></td>
                    <td class="label-cell" style="text-align: center; width: 20%;">Account / Box</td>
                    <td class="value-cell"><?= htmlspecialchars($v['cashbox_name']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">Description</td>
                    <td class="value-cell" colspan="3" style="min-height: 60px;">
                        <?= nl2br(htmlspecialchars($v['notes'])) ?>
                    </td>
                </tr>
            </table>

            <?php if ($is_inactive): ?>
                <div style="background: #fee2e2; border: 1px solid #ef4444; padding: 15px; text-align: center; font-weight: bold; color: #991b1b; margin-top: 20px;">
                    THIS RECEIPT VOUCHER IS CANCELLED AND INVALID.
                </div>
            <?php endif; ?>

            <div class="signature-section">
                <div class="sig-item">
                    <div class="sig-line"></div>
                    <div class="sig-label">ACCOUNTS DEPARTMENT<br>قسم الحسابات</div>
                </div>
                <div class="sig-item">
                    <div class="sig-line"></div>
                    <div class="sig-label">GENERAL MANAGER<br>المدير العام</div>
                </div>
            </div>
        </div>

        <div class="footer-address">
            <?= htmlspecialchars($conf['address_en']) ?> | Tel: <?= htmlspecialchars($conf['phones_en']) ?>
        </div>
    </div>
</body>
</html>