<?php
session_start();
if (!isset($_SESSION['logged_in'])) {
    header('Location: login.php');
    exit;
}

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/helpers.php'; 

// 1. التحقق من صلاحية الحذف (أو الإلغاء)
if (!can('receive', 'delete')) {
    header('Location: receive.php?error=no_permission');
    exit;
}

$id = (int)($_GET['id'] ?? 0);

if ($id > 0) {
    try {
        $pdo->beginTransaction();

        // 2. جلب بيانات السند والتأكد أنه ليس ملغى بالفعل
        $stmt = $pdo->prepare("SELECT * FROM receipt_vouchers WHERE receipt_id = ? AND status = 'Active'");
        $stmt->execute([$id]);
        $v = $stmt->fetch();

        if (!$v) {
            throw new Exception("السند غير موجود أو ملغى مسبقاً.");
        }

        $amount      = $v['amount'];
        $customer_id = $v['customer_id'];
        $cashbox_id  = $v['cashbox_id'];
        $user_id     = $_SESSION['user_id'];
        $cancel_date = date('Y-m-d H:i:s');

        // 3. تحديث حالة السند إلى Inactive بدلاً من الحذف
        $stmt_upd = $pdo->prepare("UPDATE receipt_vouchers SET status = 'Inactive' WHERE receipt_id = ?");
        $stmt_upd->execute([$id]);

        // 4. عكس أثر الصندوق: (نقص من الصندوق)
        $stmt_box = $pdo->prepare("UPDATE cash_boxes SET current_balance = current_balance - ? WHERE cashbox_id = ?");
        $stmt_box->execute([$amount, $cashbox_id]);

        // 5. عكس أثر العميل: (إضافة قيد "عليه/مدين" لموازنة القيد السابق)
        $stmt_cust = $pdo->prepare("INSERT INTO customer_transactions (customer_id, debit, credit, trans_date, description, user_id) VALUES (?, ?, 0, ?, ?, ?)");
        $desc_cancel = "Reverse: Cancellation of Receipt Voucher #$id";
        $stmt_cust->execute([$customer_id, $amount, $cancel_date, $desc_cancel, $user_id]);

        // 6. عكس اليومية العامة
        $stmt_daily = $pdo->prepare("INSERT INTO daily_transactions (trans_type, ref_id, debit, credit, description, trans_date, user_id) VALUES ('customer', ?, ?, 0, ?, ?, ?)");
        $stmt_daily->execute([$customer_id, $amount, "إلغاء سند قبض رقم #$id", $cancel_date, $user_id]);

        $pdo->commit();
        header("Location: receive.php?success=cancelled");
        exit;

    } catch (Exception $e) {
        $pdo->rollBack();
        header("Location: receive.php?error=" . urlencode($e->getMessage()));
        exit;
    }
} else {
    header("Location: receive.php?error=invalid_id");
    exit;
}