<?php
session_start();
if (!isset($_SESSION['logged_in'])) {
    header('Location: login.php');
    exit;
}

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/helpers.php';

if (!can('price_offers','view')) {
    die('Access Denied');
}
date_default_timezone_set('Asia/Aden');

$print_date = date('d/m/Y H:i');

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) { die('Invalid Offer ID'); }

$conf = $pdo->query("SELECT * FROM company_settings LIMIT 1")->fetch();

$stmt = $pdo->prepare("
    SELECT o.*,
            c.name AS customer_name,
            src.hub_name AS pol_name,
            dst.hub_name AS pod_name,
            cur.currency_code,
            ct.container_type as container_name_display 
    FROM price_offers o
    LEFT JOIN customers c ON o.customer_id = c.customer_id
    LEFT JOIN transport_hubs src ON o.source_hub_id = src.hub_id
    LEFT JOIN transport_hubs dst ON o.destination_hub_id = dst.hub_id
    LEFT JOIN currencies cur ON o.currency_id = cur.currency_id
    LEFT JOIN container_types ct ON o.container_type_id = ct.container_id
    WHERE o.offer_id = ?
");
$stmt->execute([$id]);
$o = $stmt->fetch();

if (!$o) { die('Price Offer not found'); }

$banks = $pdo->query("SELECT * FROM bank_accounts WHERE is_active = 1 LIMIT 3")->fetchAll();
$current_status = $o['status'] ?? 'Draft';
$is_expired = (in_array(strtolower($current_status), ['expired', 'cancelled', 'void']));
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Price Offer #<?= str_pad($id,6,'0',STR_PAD_LEFT) ?></title>
<style>
    @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@700;900&display=swap');
    
    @page { size: A4; margin: 10mm; }
    
    :root {
        --text-blue: #010552;
        --border-brown: #000000; 
        --pure-white: #ffffff;
    }

    body {
        font-family: 'Roboto', sans-serif;
        margin: 0; padding: 0;
        background: var(--pure-white); 
        color: var(--text-blue);
        font-size: 13px;
        font-weight: 900;
    }

    .container {
        max-width: 1000px;
        margin: auto;
        position: relative;
    }

    /* تعديل الهيدر */
    .header {
        width: 100%;
        border-bottom: 4px solid var(--border-brown);
        margin-bottom: 15px;
        padding-bottom: 10px;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .company-name {
        font-size: 16px; /* تصغير حجم الخط من 30 إلى 24 */
        text-transform: uppercase;
        line-height: 1.2;
    }

    .logo img {
        max-width: 320px;  /* تكبير عرض الصورة من 250 إلى 320 */
        max-height: 140px; /* تكبير ارتفاع الصورة من 110 إلى 140 */
        object-fit: contain;
    }

    .info-section {
        display: flex;
        gap: 15px;
        margin-bottom: 20px;
    }

    .info-box {
        flex: 1;
        border: 2px solid var(--border-brown);
    }

    .info-box h4 {
        margin: 0;
        border-bottom: 2px solid var(--border-brown);
        padding: 6px 12px;
        font-size: 16px;
        text-transform: uppercase;
    }

    .info-content {
        padding: 10px 12px;
        line-height: 1.6;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 15px;
    }

    table th, table td {
        border: 2px solid var(--border-brown);
        padding: 12px;
        text-align: center;
    }

    table th {
        font-size: 16px;
        text-transform: uppercase;
    }

    .description-table td {
        text-align: left;
        vertical-align: top;
    }

    .grand-total-box {
        width: 100%;
        border: 3px solid var(--border-brown);
        display: flex;
        margin-bottom: 20px;
    }

    .total-label {
        flex: 2;
        padding: 15px;
        text-align: right;
        font-size: 14px;
        border-right: 3px solid var(--border-brown);
    }

    .total-value {
        flex: 1;
        padding: 15px;
        text-align: center;
        font-size: 14px;
    }

    .footer-flex {
        display: flex;
        justify-content: space-between;
        margin-top: 10px;
    }

    .bank-area {
        width: 60%;
        border: 2px solid var(--border-brown);
        padding: 10px;
    }

    .signature-container {
        width: 35%;
        border: 2px solid var(--border-brown);
        padding: 15px;
        text-align: center;
    }

    .no-print {
        text-align: center; padding: 10px; background: #1e293b; margin-bottom: 10px;
    }
    .btn {
        padding: 8px 20px; color: #fff; background: #10b981; font-weight: 900; text-decoration: none; border-radius: 4px;
    }

    @media print { .no-print { display: none; } }
</style>
</head>
<body>

<div class="no-print">
    <a href="javascript:window.print()" class="btn">PRINT OFFER / طباعة العرض</a>
    <a href="javascript:history.back()" class="btn" style="background: #64748b; margin-left: 10px;">BACK / رجوع</a>
</div>

<div class="container">
    <?php if ($is_expired): ?>
        <div style="position: absolute; top: 40%; left: 25%; font-size: 80px; opacity: 0.1; transform: rotate(-45deg); font-weight: 900; border: 8px solid; padding: 10px; z-index: 0;"><?= strtoupper($current_status) ?></div>
    <?php endif; ?>

    <div class="header">
        <div style="flex: 1;">
            <div class="company-name"><?= htmlspecialchars($conf['company_name_en']) ?></div>
            <div style="margin-top: 5px; font-size: 12px;">
                                TEL: <?= htmlspecialchars($conf['phones_en']) ?>
            </div>
        </div>
        <div class="logo">
            <?php if(!empty($conf['logo_path'])): ?>
                <img src="../assets/img/<?= htmlspecialchars($conf['logo_path']) ?>">
            <?php endif; ?>
        </div>
    </div>
   <div>OFFER NO: #<?= str_pad($id,6,'0',STR_PAD_LEFT) ?></div>
    <div class="info-section">
        <div class="info-box">
            <h4>Client & Route / العميل والمسار</h4>
            <div class="info-content">
                <div>CLIENT: <?= htmlspecialchars($o['customer_name'] ?? '---') ?></div>
                <div>SHIPPING LINE: <?= htmlspecialchars($o['shipping_line'] ?: '---') ?></div>
                <div>POL: <?= htmlspecialchars($o['pol_name']) ?> </div>
                <div>POD: <?= htmlspecialchars($o['pod_name']) ?></div>
                <div>VOLUMES: <?= (int)$o['container_count'] ?> × <?= htmlspecialchars($o['container_name_display'] ?? '---') ?></div>
            </div>
        </div>
        <div class="info-box">
            <h4>Offer Details / تفاصيل العرض</h4>
            <div class="info-content">
                            <strong>Print Date:</strong> <?= $print_date ?>

                
                <div>DATE: <?= date('d/m/Y', strtotime($o['offer_date'] ?? $o['created_at'])) ?></div>
                
            </div>
        </div>
    </div>

    <table class="description-table">
        <thead>
            <tr><th style="text-align: left;">PRODUCT DESCRIPTION / وصف المنتج والخدمة</th></tr>
        </thead>
        <tbody>
            <tr>
                <td>
                    <div style="font-size: 16px; margin-bottom: 8px; text-decoration: underline;">
                        <?= htmlspecialchars($o['item_description']) ?>
                    </div>
                    <div style="line-height: 1.5; font-weight: normal;">
                        <?= nl2br(htmlspecialchars($o['shipment_details'] ?? '')) ?>
                    </div>
                </td>
            </tr>
        </tbody>
    </table>

    <table>
        <thead>
            <tr>
                <th>Order Type</th>
                <th>Quantity</th>
                <th>Volume Unit</th>
                <th>Rate (<?= $o['currency_code'] ?>)</th>
                <th>Sub-Total</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td><?= htmlspecialchars($o['shipment_type'] ?: 'Freight Services') ?></td>
                <td><?= (int)$o['container_count'] ?></td>
                <td><?= htmlspecialchars($o['container_name_display'] ?? '---') ?></td>
                <td><?= number_format($o['price_per_container'], 2) ?></td>
                <td><?= number_format($o['grand_total'], 2) ?></td>
            </tr>
        </tbody>
    </table>

    <div class="grand-total-box">
        <div class="total-label">TOTAL QUOTATION AMOUNT (<?= $o['currency_code'] ?>)</div>
        <div class="total-value"><?= number_format($o['grand_total'], 2) ?></div>
    </div>

    <div class="footer-flex">
        <div class="bank-area">
            <div style="text-decoration: underline; margin-bottom: 8px;">BANK ACCOUNT DETAILS (FOR PAYMENT):</div>
            <?php foreach($banks as $b): ?>
                <div style="margin-bottom: 4px;">
                    <?= htmlspecialchars($b['bank_name_ar'] ?? $b['bank_name']) ?>: 
                    <span><?= htmlspecialchars($b['account_number']) ?></span>
                </div>
            <?php endforeach; ?>
        </div>

        <div class="signature-container">
            <div style="font-size: 12px; margin-bottom: 5px;">FOR <?= htmlspecialchars($conf['company_name_en']) ?></div>
            <div style="height: 60px;"></div> 
            <div style="border-top: 2px solid var(--border-brown); padding-top: 5px;">AUTHORISED SIGNATORY</div>
        </div>
    </div>

    <div class="footer-text" style="text-align: center; margin-top: 20px; border-top: 2px solid #000; padding-top: 10px;">
        <?= htmlspecialchars($conf['footer_text_en'] ?? 'This offer is valid for a limited time.') ?>
        
    </div>
</div>

</body>
</html>

                
                