<?php
session_start();
require_once __DIR__ . '/../config/database.php';

$search = trim($_GET['search'] ?? '');
$f_status = trim($_GET['f_status'] ?? '');

$conditions = ["1=1"];
$params = [];

if ($search !== '') {
    $conditions[] = "(shipping_line LIKE ? OR item_description LIKE ? OR offer_details LIKE ?)";
    $params[] = "%$search%"; $params[] = "%$search%"; $params[] = "%$search%";
}

if ($f_status === 'Active') {
    $conditions[] = "(status = 'Active' OR status = 'approved')";
} elseif ($f_status === 'Inactive') {
    $conditions[] = "(status = 'Inactive' OR status = 'rejected')";
}

$where = "WHERE " . implode(" AND ", $conditions);
$stmt = $pdo->prepare("SELECT * FROM price_offers $where ORDER BY offer_id DESC");
$stmt->execute($params);
$offers = $stmt->fetchAll();

$conf = $pdo->query("SELECT * FROM company_settings LIMIT 1")->fetch();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Price Offers Report</title>
<style>
    body { font-family: 'Segoe UI', sans-serif; padding: 20px; font-size: 12px; color: #333; }
    .no-print { background: #1e293b; color: white; padding: 15px; text-align: center; margin: -20px -20px 20px -20px; }
    .btn { padding: 8px 20px; background: #10b981; color: white; text-decoration: none; border-radius: 5px; font-weight: bold; border:none; cursor:pointer; }
    .header-table { width: 100%; border-bottom: 2px solid #000; margin-bottom: 20px; }
    .report-table { width: 100%; border-collapse: collapse; }
    .report-table th { background: #f1f5f9; border: 1px solid #94a3b8; padding: 8px; text-align: left; font-size: 10px; text-transform: uppercase; }
    .report-table td { border: 1px solid #94a3b8; padding: 8px; }
    .total-row { background: #f8fafc; font-weight: bold; }
    @media print { .no-print { display: none; } body { padding: 0; } }
</style>
</head>
<body>

<div class="no-print">
    <button class="btn" onclick="window.print()">Confirm Print</button>
    <button class="btn" style="background:#64748b" onclick="window.history.back()">Back</button>
</div>

<table class="header-table">
    <tr>
        <td width="33%"><strong><?= $conf['company_name_en'] ?></strong></td>
        <td width="33%" align="center"><h1>PRICE OFFERS LIST</h1></td>
        <td width="33%" align="right"><strong><?= $conf['company_name_ar'] ?></strong></td>
    </tr>
</table>

<table class="report-table">
    <thead>
        <tr>
            <th>ID</th>
            <th>Date</th>
            <th>Shipping Line</th>
            <th>Description</th>
            <th>Qty</th>
            <th>Unit Price</th>
            <th>Grand Total</th>
        </tr>
    </thead>
    <tbody>
        <?php 
        $grand_total_sum = 0;
        foreach ($offers as $o): 
            $grand_total_sum += $o['grand_total'];
        ?>
        <tr>
            <td>#<?= $o['offer_id'] ?></td>
            <td><?= $o['offer_date'] ?></td>
            <td><?= htmlspecialchars($o['shipping_line']) ?></td>
            <td><?= htmlspecialchars($o['item_description']) ?></td>
            <td><?= $o['container_count'] ?></td>
            <td><?= number_format($o['price_per_container'], 2) ?></td>
            <td><strong><?= number_format($o['grand_total'], 2) ?></strong></td>
        </tr>
        <?php endforeach; ?>
    </tbody>
    <tfoot>
        <tr class="total-row">
            <td colspan="6" align="right">REPORT TOTAL SUM:</td>
            <td>$<?= number_format($grand_total_sum, 2) ?></td>
        </tr>
    </tfoot>
</table>

</body>
</html>