<?php
require_once '../src/auth.php';
require_once '../config/database.php';

// التحقق من صلاحية الوصول لهذه الصفحة
authorize($pdo, 'permissions', 'can_view');

// 1. معالجة إضافة صلاحية جديدة
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['add_new'])) {
    authorize($pdo, 'permissions', 'can_add');
    
    $page_name = $_POST['new_page_name'];
    $role_id   = $_POST['new_role_id'];
    
    // تأمين إضافي: منع الإضافة للدور رقم 1 برمجياً حتى لو تم التلاعب بالطلب
    if($role_id == 1) die("غير مسموح بتعديل صلاحيات هذا الدور.");

    $view   = isset($_POST['new_view']) ? 1 : 0;
    $add    = isset($_POST['new_add']) ? 1 : 0;
    $edit   = isset($_POST['new_edit']) ? 1 : 0;
    $delete = isset($_POST['new_delete']) ? 1 : 0;
    $print  = isset($_POST['new_print']) ? 1 : 0;

    $sql = "INSERT INTO permissions (role_id, page_name, can_view, can_add, can_edit, can_delete, can_print) 
            VALUES (?, ?, ?, ?, ?, ?, ?)";
    $pdo->prepare($sql)->execute([$role_id, $page_name, $view, $add, $edit, $delete, $print]);
    header("Location: " . $_SERVER['PHP_SELF'] . "?success=added");
    exit;
}

// 2. معالجة تحديث الصلاحيات الحالية
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['update_all'])) {
    authorize($pdo, 'permissions', 'can_edit');
    
    foreach ($_POST['perm'] as $id => $cols) {
        $v = isset($cols['can_view']) ? 1 : 0;
        $a = isset($cols['can_add']) ? 1 : 0;
        $e = isset($cols['can_edit']) ? 1 : 0;
        $d = isset($cols['can_delete']) ? 1 : 0;
        $p = isset($cols['can_print']) ? 1 : 0;

        // التحديث يتم فقط للأسطر المعروضة (والتي استثنينا منها role_id 1 في العرض)
        $sql = "UPDATE permissions SET can_view=?, can_add=?, can_edit=?, can_delete=?, can_print=? WHERE perm_id=?";
        $pdo->prepare($sql)->execute([$v, $a, $e, $d, $p, $id]);
    }
    header("Location: " . $_SERVER['PHP_SELF'] . "?success=updated");
    exit;
}

// جلب البيانات مع استثناء الدور رقم 1
$permissions = $pdo->query("SELECT p.*, r.role_name 
                            FROM permissions p 
                            JOIN roles r ON p.role_id = r.role_id 
                            WHERE p.role_id != 1")->fetchAll(PDO::FETCH_ASSOC);

// جلب الأدوار مع استثناء الدور رقم 1 لقائمة الاختيار
$roles = $pdo->query("SELECT * FROM roles WHERE role_id != 1")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>إدارة الصلاحيات</title>
    <link rel="stylesheet" href="../assets/css/bootstrap.rtl.min.css">
    <style>
        body { background-color: #f4f7f6; font-family: 'Segoe UI', sans-serif; }
        .table-container { background: white; border-radius: 10px; padding: 20px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
        .form-check-input { width: 1.2em; height: 1.2em; cursor: pointer; border-color: #0d6efd; }
    </style>
</head>
<body>
 <a href="dashboard.php" class="btn btn-gray">
                <i class="fas fa-arrow-left"></i> Back
            </a>
<div class="container my-5">
    <h3 class="mb-4"><i class="bi bi-shield-lock"></i> التحكم بصلاحيات الموظفين</h3>

    <?php if(isset($_GET['success'])): ?>
        <div class="alert alert-success alert-dismissible fade show">تم تحديث البيانات بنجاح!</div>
    <?php endif; ?>

    <div class="card mb-4 border-0 shadow-sm">
        <div class="card-header bg-dark text-white">إضافة صلاحية جديدة (مستثنى منها المدير العام)</div>
        <div class="card-body bg-light">
            <form method="POST" class="row g-3">
                <div class="col-md-3">
                    <input type="text" name="new_page_name" class="form-control" placeholder="اسم الصفحة بالإنجليزية..." required>
                </div>
                <div class="col-md-2">
                    <select name="new_role_id" class="form-select" required>
                        <option value="">اختر الدور...</option>
                        <?php foreach($roles as $role): ?>
                            <option value="<?= $role['role_id'] ?>"><?= $role['role_name'] ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-7 d-flex align-items-center justify-content-between border rounded px-3 bg-white">
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="checkbox" name="new_view" id="v"> <label for="v">عرض</label>
                    </div>
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="checkbox" name="new_add" id="a"> <label for="a">إضافة</label>
                    </div>
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="checkbox" name="new_edit" id="e"> <label for="e">تعديل</label>
                    </div>
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="checkbox" name="new_delete" id="d"> <label for="d">حذف</label>
                    </div>
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="checkbox" name="new_print" id="p"> <label for="p">طباعة</label>
                    </div>
                    <button type="submit" name="add_new" class="btn btn-primary btn-sm px-4">إضافة</button>
                </div>
            </form>
        </div>
    </div>

    <div class="table-container">
        <form method="POST">
            <table class="table table-hover align-middle">
                <thead class="table-light text-center">
                    <tr>
                        <th class="text-start">اسم الصفحة</th>
                        <th>الدور</th>
                        <th>عرض</th>
                        <th>إضافة</th>
                        <th>تعديل</th>
                        <th>حذف</th>
                        <th>طباعة</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($permissions as $row): ?>
                    <tr class="text-center">
                        <td class="text-start fw-bold text-primary"><?= htmlspecialchars($row['page_name']) ?></td>
                        <td><span class="badge bg-secondary rounded-pill"><?= htmlspecialchars($row['role_name']) ?></span></td>
                        <td><?= renderCheckbox($row['perm_id'], 'can_view', $row['can_view']) ?></td>
                        <td><?= renderCheckbox($row['perm_id'], 'can_add', $row['can_add']) ?></td>
                        <td><?= renderCheckbox($row['perm_id'], 'can_edit', $row['can_edit']) ?></td>
                        <td><?= renderCheckbox($row['perm_id'], 'can_delete', $row['can_delete']) ?></td>
                        <td><?= renderCheckbox($row['perm_id'], 'can_print', $row['can_print']) ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <div class="mt-4 pt-3 border-top">
                <button type="submit" name="update_all" class="btn btn-success float-end">حفظ كافة التغييرات</button>
            </div>
        </form>
    </div>
</div>

<?php
function renderCheckbox($id, $column, $value) {
    $checked = ($value == 1) ? 'checked' : '';
    return "<input type='checkbox' class='form-check-input' name='perm[$id][$column]' value='1' $checked>";
}
?>

</body>
</html>