<?php
session_start();
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/helpers.php';

// التأكد من الصلاحية والمعرف
if (!can('pay', 'delete')) die('Access Denied');
$id = (int)($_GET['id'] ?? 0);

if ($id > 0) {
    try {
        // 1. جلب بيانات السند كاملة
        $stmt = $pdo->prepare("SELECT * FROM payment_vouchers WHERE payment_id = ?");
        $stmt->execute([$id]);
        $v = $stmt->fetch();

        if (!$v || strtolower($v['status']) == 'inactive') die('Invalid Voucher or Already Voided');

        $pdo->beginTransaction();

        // 2. ترحيل عكسي للصندوق (إعادة المبلغ)
        $pdo->prepare("UPDATE cash_boxes SET current_balance = current_balance + ? WHERE cashbox_id = ?")
            ->execute([$v['amount'], $v['cashbox_id']]);

        // 3. ترحيل عكسي لحساب الوكيل (إضافة حركة دائنة Credit)
        if ($v['pay_type'] == 'agent' && $v['ref_id']) {
            $pdo->prepare("INSERT INTO agent_transactions (agent_id, debit, credit, trans_date, description, user_id) VALUES (?, 0, ?, NOW(), ?, ?)")
                ->execute([$v['ref_id'], $v['amount'], "Void Voucher #".$v['payment_no'], $_SESSION['user_id']]);
        }

        // 4. ترحيل عكسي للقيود اليومية (إضافة حركة دائنة Credit)
        $pdo->prepare("INSERT INTO daily_transactions (trans_type, ref_id, debit, credit, description, trans_date, user_id) VALUES ('agent', ?, 0, ?, ?, NOW(), ?)")
            ->execute([$v['ref_id'], $v['amount'], "Voiding Payment #".$v['payment_no'], $_SESSION['user_id']]);

        // 5. إغلاق السند
        $pdo->prepare("UPDATE payment_vouchers SET status = 'inactive' WHERE payment_id = ?")->execute([$id]);

        $pdo->commit();
        header("Location: pay.php?success=Voucher_Voided");

    } catch (Exception $e) {
        if ($pdo->inTransaction()) $pdo->rollBack();
        die("Error: " . $e->getMessage());
    }
}