<?php
session_start();
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/helpers.php';

if (!can('line', 'edit')) die('Access Denied');

$id = $_GET['id'] ?? 0;
$stmt = $pdo->prepare("SELECT * FROM shipping_lines WHERE line_id = ?");
$stmt->execute([$id]);
$data = $stmt->fetch();

if (!$data) die('Record not found');

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $stmt = $pdo->prepare("UPDATE shipping_lines SET line_name=?, contact_person=?, status=? WHERE line_id=?");
    $stmt->execute([$_POST['line_name'], $_POST['contact_person'], $_POST['status'], $id]);
    header("Location: line.php?msg=updated");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Edit Shipping Line</title>
    <link href="../assets/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-5">
            <div class="card shadow-sm border-0 rounded-4">
                <div class="card-header bg-dark text-white p-3 rounded-top-4">
                    <h5 class="mb-0">Update Carrier: <?= htmlspecialchars($data['line_name']) ?></h5>
                </div>
                <div class="card-body p-4">
                    <form method="POST">
                        <div class="mb-3">
                            <label class="form-label fw-bold small text-muted">Carrier Name</label>
                            <input type="text" name="line_name" class="form-control" value="<?= htmlspecialchars($data['line_name']) ?>" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold small text-muted">Contact Person</label>
                            <input type="text" name="contact_person" class="form-control" value="<?= htmlspecialchars($data['contact_person']) ?>">
                        </div>
                        <div class="mb-4">
                            <label class="form-label fw-bold small text-muted">Status</label>
                            <select name="status" class="form-select">
                                <option value="active" <?= $data['status'] == 'active' ? 'selected' : '' ?>>Active</option>
                                <option value="inactive" <?= $data['status'] == 'inactive' ? 'selected' : '' ?>>Inactive</option>
                            </select>
                        </div>
                        <div class="d-flex justify-content-between pt-3 border-top">
                            <a href="line.php" class="btn btn-light px-4">Back</a>
                            <button type="submit" class="btn btn-dark px-4">Update Details</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>