<?php
session_start();
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/helpers.php';

if (!can('line', 'add')) die('Access Denied');

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $stmt = $pdo->prepare("INSERT INTO shipping_lines (line_name, contact_person, status) VALUES (?, ?, ?)");
    $stmt->execute([$_POST['line_name'], $_POST['contact_person'], $_POST['status']]);
    header("Location: line.php?msg=added");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Add Shipping Line</title>
    <link href="../assets/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-5">
            <div class="card shadow-sm border-0 rounded-4">
                <div class="card-header bg-primary text-white p-3 rounded-top-4">
                    <h5 class="mb-0">Add New Shipping Carrier</h5>
                </div>
                <div class="card-body p-4">
                    <form method="POST">
                        <div class="mb-3">
                            <label class="form-label fw-bold small text-muted">Carrier / Line Name</label>
                            <input type="text" name="line_name" class="form-control" placeholder="e.g. MAERSK, MSC, COSCO" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold small text-muted">Contact Person</label>
                            <input type="text" name="contact_person" class="form-control" placeholder="Name or Department">
                        </div>
                        <div class="mb-4">
                            <label class="form-label fw-bold small text-muted">Status</label>
                            <select name="status" class="form-select">
                                <option value="active">Active</option>
                                <option value="inactive">Inactive</option>
                            </select>
                        </div>
                        <div class="d-flex justify-content-between pt-3 border-top">
                            <a href="line.php" class="btn btn-light px-4">Cancel</a>
                            <button type="submit" class="btn btn-primary px-4">Save Carrier</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>