<?php
session_start();
if (!isset($_SESSION['logged_in'])) {
    header('Location: login.php');
    exit;
}

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/helpers.php';

if (!can('line', 'view')) {
    die('Access Denied');
}

// Handle Delete
if (isset($_GET['delete'])) {
    if (!can('line', 'delete')) die('Access Denied');
    $stmt = $pdo->prepare("DELETE FROM shipping_lines WHERE line_id = ?");
    $stmt->execute([$_GET['delete']]);
    header("Location: shipping_lines.php?msg=deleted");
    exit;
}

$lines = $pdo->query("SELECT * FROM shipping_lines ORDER BY line_id DESC")->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Shipping Lines Management</title>
    <link href="../assets/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../assets/font-awesome/css/all.min.css">
    <style>
        :root { --primary: #0f172a; --accent: #3b82f6; --bg: #f8fafc; }
        body { background: var(--bg); font-family: 'Inter', sans-serif; }
        .page-header { background: white; padding: 20px; border-bottom: 1px solid #e2e8f0; margin-bottom: 30px; }
        .main-card { background: white; border-radius: 12px; border: 1px solid #e2e8f0; box-shadow: 0 1px 3px rgba(0,0,0,0.1); overflow: hidden; }
        .table thead th { background: #f1f5f9; color: #475569; font-size: 11px; text-transform: uppercase; letter-spacing: 0.05em; padding: 15px; }
        .status-badge { padding: 4px 10px; border-radius: 6px; font-size: 10px; font-weight: 800; text-transform: uppercase; }
        .status-active { background: #dcfce7; color: #166534; }
        .status-inactive { background: #fee2e2; color: #991b1b; }
    </style>
</head>
<body>

<div class="page-header">
    <div class="container d-flex justify-content-between align-items-center">
        <h4 class="m-0"><i class="fas fa-ship me-2 text-primary"></i> Shipping Lines</h4>
        <div class="d-flex gap-2">
            <a href="dashboard.php" class="btn btn-outline-secondary btn-sm">Dashboard</a>
            <a href="line_add.php" class="btn btn-primary btn-sm px-4"><i class="fas fa-plus me-1"></i> Add New Line</a>
        </div>
    </div>
</div>

<div class="container">
    <?php if(isset($_GET['msg'])): ?>
        <div class="alert alert-success border-0 shadow-sm alert-dismissible fade show">
            Database updated successfully!
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <div class="card main-card">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead>
                    <tr>
                        <th width="80">ID</th>
                        <th>Carrier Name</th>
                        <th>Contact Person</th>
                        <th>Status</th>
                        <th>Registration Date</th>
                        <th width="120" class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($lines as $line): ?>
                    <tr>
                        <td class="text-muted">#<?= $line['line_id'] ?></td>
                        <td>
                            <div class="d-flex align-items-center">
                                <div class="bg-light p-2 rounded me-3"><i class="fas fa-industry text-secondary"></i></div>
                                <strong><?= htmlspecialchars($line['line_name']) ?></strong>
                            </div>
                        </td>
                        <td><?= htmlspecialchars($line['contact_person'] ?: 'N/A') ?></td>
                        <td>
                            <span class="status-badge <?= $line['status'] == 'active' ? 'status-active' : 'status-inactive' ?>">
                                <?= $line['status'] ?>
                            </span>
                        </td>
                        <td class="text-muted small"><?= date('M d, Y', strtotime($line['created_at'])) ?></td>
                        <td class="text-center">
                            <a href="line_edit.php?id=<?= $line['line_id'] ?>" class="btn btn-sm btn-light border"><i class="fas fa-edit text-primary"></i></a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    function confirmDelete(id) {
        Swal.fire({
            title: 'Delete Shipping Line?',
            text: "All associated shipment records may be affected.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#ef4444',
            confirmButtonText: 'Yes, delete'
        }).then((result) => {
            if (result.isConfirmed) window.location.href = 'shipping_lines.php?delete=' + id;
        });
    }
</script>
</body>
</html>