<?php
require_once '../src/auth.php';
protectPage();

$message = '';
$messageType = '';


// التحقق من صلاحية "الفواتير"
// نفترض أن دالة checkPermission موجودة في auth.php
authorize($pdo, 'invoice', 'can_add');

// جلب الشحنات التي لها مبالغ مالية مسجلة لإصدار فاتورة
$query = "SELECT s.*, c.name as customer_name, curr.currency_code 
          FROM shipments s
          JOIN customers c ON s.customer_id = c.customer_id
          LEFT JOIN currencies curr ON s.currency_id = curr.currency_id
          WHERE s.customer_total_price > 0
          ORDER BY s.created_at DESC";
$stmt = $pdo->query($query);
$invoices = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>إدارة الفواتير | نظام الملاحة</title>
    <link rel="stylesheet" href="../assets/font-awesome/css/all.min.css">
    <link rel="stylesheet" href="../assets/css/select2.min.css">
    <style>
        :root { --primary: #2c3e50; --accent: #2980b9; }
        body { font-family: 'Segoe UI', sans-serif; background: #f4f7f6; margin: 0; display: flex; }
        .sidebar { width: 260px; background: var(--primary); height: 100vh; position: fixed; right: 0; }
        .main-content { margin-right: 260px; flex: 1; padding: 30px; }
        .invoice-table { width: 100%; border-collapse: collapse; background: white; border-radius: 10px; overflow: hidden; }
        .invoice-table th, .invoice-table td { padding: 15px; border-bottom: 1px solid #eee; text-align: right; }
        .invoice-table th { background: #34495e; color: white; }
        .btn-view { background: #27ae60; color: white; padding: 5px 12px; border-radius: 4px; text-decoration: none; font-size: 0.9rem; }
    </style>
</head>
<body>
    <div class="sidebar">
        <div style="padding: 20px; text-align: center; color: white; font-weight: bold;">نظام الملاحة</div>
        <a href="dashboard.php" style="display:block; padding:15px; color:white; text-decoration:none;"><i class="fas fa-home"></i> الرئيسية</a>
    </div>

    <div class="main-content">
        <h2><i class="fas fa-file-invoice-dollar"></i> فواتير الشحنات</h2>
        
        <table class="invoice-table">
            <thead>
                <tr>
                    <th>رقم الفاتورة</th>
                    <th>العميل</th>
                    <th>وصف الشحنة</th>
                    <th>المبلغ الإجمالي</th>
                    <th>تاريخ الإصدار</th>
                    <th>إجراءات</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($invoices as $inv): ?>
                <tr>
                    <td>INV-<?= $inv['shipment_id'] ?></td>
                    <td><?= htmlspecialchars($inv['customer_name']) ?></td>
                    <td><?= htmlspecialchars($inv['item_description']) ?></td>
                    <td style="font-weight: bold; color: #2c3e50;">
                        <?= number_format($inv['customer_total_price'], 2) ?> <?= $inv['currency_code'] ?>
                    </td>
                    <td><?= date('Y-m-d', strtotime($inv['created_at'])) ?></td>
                    <td>
                        <a href="shipment_print_invoice.php?id=<?= $inv['shipment_id'] ?>" class="btn-view">
                            <i class="fas fa-print"></i> عرض وطباعة
                        </a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</body>
</html>