<?php
session_start();
if (!isset($_SESSION['logged_in'])) {
    header('Location: login.php');
    exit;
}

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/helpers.php';

if (!can('hubs', 'view')) {
    die('Access Denied');
}

// Handle Delete
if (isset($_GET['delete'])) {
    if (!can('hubs', 'delete')) die('Access Denied');
    $stmt = $pdo->prepare("DELETE FROM transport_hubs WHERE hub_id = ?");
    $stmt->execute([$_GET['delete']]);
    header("Location: hubs.php?msg=deleted");
    exit;
}

$hubs = $pdo->query("SELECT * FROM transport_hubs ORDER BY hub_id DESC")->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Transport Hubs Management</title>
    <link href="../assets/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../assets/font-awesome/css/all.min.css">
    <style>
        :root { --primary: #1e293b; --accent: #0284c7; --bg: #f8fafc; }
        body { background: var(--bg); font-family: 'Inter', sans-serif; }
        .page-header { background: white; padding: 20px; border-bottom: 1px solid #e2e8f0; margin-bottom: 30px; }
        .main-card { background: white; border-radius: 12px; border: 1px solid #e2e8f0; box-shadow: 0 1px 3px rgba(0,0,0,0.1); }
        .table thead th { background: #f1f5f9; color: #475569; font-size: 12px; text-transform: uppercase; letter-spacing: 0.05em; padding: 15px; }
        .hub-badge { padding: 5px 12px; border-radius: 50px; font-size: 11px; font-weight: 700; }
        .badge-port { background: #e0f2fe; color: #0369a1; }
        .badge-airport { background: #fef3c7; color: #92400e; }
        .badge-land { background: #dcfce7; color: #166534; }
    </style>
</head>
<body>

<div class="page-header">
    <div class="container d-flex justify-content-between align-items-center">
        <h4 class="m-0"><i class="fas fa-ship me-2 text-primary"></i> Transport Hubs</h4>
        <div class="d-flex gap-2">
            <a href="dashboard.php" class="btn btn-outline-secondary btn-sm"><i class="fas fa-arrow-left"></i> Dashboard</a>
            <a href="hub_add.php" class="btn btn-primary btn-sm px-4"><i class="fas fa-plus me-1"></i> Add New Hub</a>
        </div>
    </div>
</div>

<div class="container">
    <?php if(isset($_GET['msg'])): ?>
        <div class="alert alert-success alert-dismissible fade show">
            Operation completed successfully!
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <div class="card main-card">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead>
                    <tr>
                        <th width="80">ID</th>
                        <th>Hub Name</th>
                        <th>Type</th>
                        <th>Country / City</th>
                        <th width="150" class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($hubs as $hub): ?>
                    <tr>
                        <td class="text-muted">#<?= $hub['hub_id'] ?></td>
                        <td><strong><?= htmlspecialchars($hub['hub_name']) ?></strong></td>
                        <td>
                            <?php 
                                $cls = ($hub['hub_type'] == 'Port') ? 'badge-port' : (($hub['hub_type'] == 'Airport') ? 'badge-airport' : 'badge-land');
                            ?>
                            <span class="hub-badge <?= $cls ?>"><?= $hub['hub_type'] ?></span>
                        </td>
                        <td>
                            <i class="fas fa-map-marker-alt text-danger me-1 small"></i>
                            <?= htmlspecialchars($hub['country']) ?>, <?= htmlspecialchars($hub['city']) ?>
                        </td>
                        <td class="text-center">
                            <a href="hub_edit.php?id=<?= $hub['hub_id'] ?>" class="btn btn-sm btn-light border me-1"><i class="fas fa-edit text-primary"></i></a>
                            <button onclick="confirmDelete(<?= $hub['hub_id'] ?>)" class="btn btn-sm btn-light border"><i class="fas fa-trash text-danger"></i></button>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    function confirmDelete(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "This hub will be permanently deleted!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#ef4444',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) window.location.href = 'hubs.php?delete=' + id;
        });
    }
</script>
</body>
</html>