<?php
session_start();
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/helpers.php';

if (!can('hubs', 'edit')) die('Access Denied');

$id = $_GET['id'] ?? 0;
$hub = $pdo->prepare("SELECT * FROM transport_hubs WHERE hub_id = ?");
$hub->execute([$id]);
$data = $hub->fetch();

if (!$data) die('Hub not found');

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $stmt = $pdo->prepare("UPDATE transport_hubs SET hub_name=?, hub_type=?, country=?, city=? WHERE hub_id=?");
    $stmt->execute([$_POST['hub_name'], $_POST['hub_type'], $_POST['country'], $_POST['city'], $id]);
    header("Location: hubs.php?msg=updated");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Edit Hub</title>
    <link href="../assets/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card shadow-sm border-0 rounded-4">
                <div class="card-header bg-dark text-white p-3 rounded-top-4">
                    <h5 class="mb-0 text-white">Edit Hub: <?= htmlspecialchars($data['hub_name']) ?></h5>
                </div>
                <div class="card-body p-4">
                    <form method="POST">
                        <div class="mb-3">
                            <label class="form-label fw-bold small">Hub Name</label>
                            <input type="text" name="hub_name" class="form-control" value="<?= htmlspecialchars($data['hub_name']) ?>" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold small">Hub Type</label>
                            <select name="hub_type" class="form-select" required>
                                <option value="Port" <?= $data['hub_type'] == 'Port' ? 'selected' : '' ?>>Port</option>
                                <option value="Airport" <?= $data['hub_type'] == 'Airport' ? 'selected' : '' ?>>Airport</option>
                                <option value="Land Terminal" <?= $data['hub_type'] == 'Land Terminal' ? 'selected' : '' ?>>Land Terminal</option>
                            </select>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold small">Country</label>
                                <input type="text" name="country" class="form-control" value="<?= htmlspecialchars($data['country']) ?>" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold small">City</label>
                                <input type="text" name="city" class="form-control" value="<?= htmlspecialchars($data['city']) ?>" required>
                            </div>
                        </div>
                        <hr>
                        <div class="d-flex justify-content-between">
                            <a href="hubs.php" class="btn btn-light px-4">Back</a>
                            <button type="submit" class="btn btn-dark px-4">Update Hub</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>