<?php
session_start();
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/helpers.php';

if (!can('hubs', 'add')) die('Access Denied');

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $stmt = $pdo->prepare("INSERT INTO transport_hubs (hub_name, hub_type, country, city) VALUES (?, ?, ?, ?)");
    $stmt->execute([$_POST['hub_name'], $_POST['hub_type'], $_POST['country'], $_POST['city']]);
    header("Location: hubs.php?msg=added");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Add New Hub</title>
    <link href="../assets/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card shadow-sm border-0 rounded-4">
                <div class="card-header bg-primary text-white p-3 rounded-top-4">
                    <h5 class="mb-0">Add New Transport Hub</h5>
                </div>
                <div class="card-body p-4">
                    <form method="POST">
                        <div class="mb-3">
                            <label class="form-label fw-bold small">Hub Name</label>
                            <input type="text" name="hub_name" class="form-control" placeholder="e.g. Jebel Ali Port" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold small">Hub Type</label>
                            <select name="hub_type" class="form-select" required>
                                <option value="Port">Port</option>
                                <option value="Airport">Airport</option>
                                <option value="Land Terminal">Land Terminal</option>
                            </select>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold small">Country</label>
                                <input type="text" name="country" class="form-control" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold small">City</label>
                                <input type="text" name="city" class="form-control" required>
                            </div>
                        </div>
                        <hr>
                        <div class="d-flex justify-content-between">
                            <a href="hubs.php" class="btn btn-light px-4">Cancel</a>
                            <button type="submit" class="btn btn-primary px-4">Save Hub</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>