<?php
session_start();
if (!isset($_SESSION['logged_in'])) {
    header('Location: login.php');
    exit;
}

require_once __DIR__ . '/../config/database.php';

$message = "";

// تحديد المسار الثابت الذي طلبته
$target_path = "d:\\shipping";

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['run_export'])) {
    try {
        // 1. التأكد من وجود المجلد أو محاولة إنشائه
        if (!is_dir($target_path)) {
            if (!mkdir($target_path, 0777, true)) {
                throw new Exception("المسار $target_path غير موجود وفشل النظام في إنشائه. تأكد من وجود القرص E:");
            }
        }

        // 2. التحقق من صلاحية الكتابة
        if (!is_writable($target_path)) {
            throw new Exception("لا توجد صلاحية للكتابة في المسار المحدد ($target_path).");
        }

        // --- بدء جلب البيانات ---
        $tables = [];
        $query = $pdo->query("SHOW TABLES");
        while ($row = $query->fetch(PDO::FETCH_NUM)) { $tables[] = $row[0]; }

        $sql_content = "-- Database Backup\n-- Path: $target_path\n-- Generated: " . date('Y-m-d H:i:s') . "\nSET FOREIGN_KEY_CHECKS=0;\n";

        foreach ($tables as $table) {
            $showTable = $pdo->query("SHOW CREATE TABLE `$table`")->fetch(PDO::FETCH_ASSOC);
            $sql_content .= "\nDROP TABLE IF EXISTS `$table`;\n" . $showTable['Create Table'] . ";\n";
            $rows = $pdo->query("SELECT * FROM `$table`")->fetchAll(PDO::FETCH_ASSOC);
            foreach ($rows as $row) {
                $escapedValues = array_map(function($v) use ($pdo) { return ($v === null) ? "NULL" : $pdo->quote($v); }, array_values($row));
                $sql_content .= "INSERT INTO `$table` VALUES (" . implode(", ", $escapedValues) . ");\n";
            }
        }
        $sql_content .= "\nSET FOREIGN_KEY_CHECKS=1;";

        // اسم الملف
        $filename = "backup_" . date("Y-m-d_H-i-s") . ".sql";
        $full_file_path = $target_path . DIRECTORY_SEPARATOR . $filename;

        // 3. حفظ الملف فعلياً في المسار المحدد
        if (file_put_contents($full_file_path, $sql_content)) {
            $message = "<div class='alert alert-success'>✅ تم حفظ النسخة بنجاح في المسار المطلوب:<br><code>$full_file_path</code></div>";
        } else {
            throw new Exception("فشل في كتابة الملف في المسار المحدد.");
        }

    } catch (Exception $e) {
        $message = "<div class='alert alert-danger'>❌ خطأ: " . $e->getMessage() . "</div>";
    }
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>تصدير للقرض E</title>
    <link href="../assets/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../assets/font-awesome/css/all.min.css">
    <style>
        body { background: #f4f7f6; }
        .export-card { max-width: 600px; margin: 100px auto; border-radius: 15px; box-shadow: 0 10px 30px rgba(0,0,0,0.1); border: none; }
        .path-label { background: #e9ecef; padding: 10px; border-radius: 8px; font-family: monospace; display: block; margin-top: 10px; color: #d63384; }
    </style>
</head>
<body>

<div class="container">
    <div class="card export-card">
        <div class="card-header bg-dark text-white p-4 text-center">
            <h5 class="mb-0"><i class="fas fa-hdd me-2"></i> التصدير إلى القرص D:</h5>
        </div>
        <div class="card-body p-4">
            <?= $message ?>
            
            <div class="text-center mb-4">
                <p>سيتم حفظ نسخة قاعدة البيانات مباشرة في المجلد التالي:</p>
                <span class="path-label">D:\shipping</span>
            </div>

            <form method="POST">
                <div class="d-grid">
                    <button type="submit" name="run_export" class="btn btn-success btn-lg shadow">
                        <i class="fas fa-play-circle me-2"></i> تنفيذ عملية الحفظ الآن
                    </button>
                </div>
            </form>

            <div class="text-center mt-4">
                <a href="dashboard.php" class="btn btn-link text-secondary">
                    <i class="fas fa-arrow-right me-1"></i> العودة للوحة التحكم
                </a>
            </div>
        </div>
    </div>
</div>

</body>
</html>