<?php
session_start();
if (!isset($_SESSION['logged_in'])) {
    header('Location: login.php');
    exit;
}

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/helpers.php';

// التحقق من الصلاحيات
if (!can('expenses', 'delete')) {
    die('Access Denied: You do not have permission to cancel discounts.');
}

// التحقق من وجود المعرف (ID)
$trans_id = $_GET['id'] ?? null;

if (!$trans_id) {
    header('Location: expenses.php?error=MissingID');
    exit;
}

try {
    // 1. التأكد من أن المعاملة موجودة وهي فعلاً "خصم" قبل الإلغاء
    $check_stmt = $pdo->prepare("SELECT * FROM expense_transactions WHERE trans_id = ?");
    $check_stmt->execute([$trans_id]);
    $transaction = $check_stmt->fetch();

    if (!$transaction) {
        header('Location: expenses.php?error=NotFound');
        exit;
    }

    // 2. تحديث الحالة إلى canceled
    // ملاحظة: لا نقوم بتعديل مبلغ الصندوق لأن الخصم في الأساس ليس حركة كاش فعلية
    $update_stmt = $pdo->prepare("
        UPDATE expense_transactions 
        SET status = 'canceled' 
        WHERE trans_id = ?
    ");
    
    if ($update_stmt->execute([$trans_id])) {
        // النجاح والعودة لصفحة المصاريف مع رسالة تأكيد
        header('Location: expenses.php?msg=DiscountCanceled');
    } else {
        header('Location: expenses.php?error=FailedUpdate');
    }

} catch (PDOException $e) {
    // في حال حدوث خطأ في قاعدة البيانات
    die("Error: " . $e->getMessage());
}