<?php
session_start();
if (!isset($_SESSION['logged_in'])) {
    header('Location: login.php');
    exit;
}

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/helpers.php';

// التحقق من صلاحية الحذف
if (!can('expenses', 'delete')) {
    die('Access Denied');
}

$trans_id = $_GET['id'] ?? 0;

if ($trans_id) {
    try {
        $pdo->beginTransaction();

        // 1. جلب بيانات السند قبل التعديل
        $stmt = $pdo->prepare("SELECT amount, description, box_id, status FROM expense_transactions WHERE trans_id = ? FOR UPDATE");
        $stmt->execute([$trans_id]);
        $trans = $stmt->fetch();

        if (!$trans) throw new Exception("Transaction not found.");
        if ($trans['status'] === 'canceled') throw new Exception("Already deleted.");

        $old_amount = $trans['amount'];
        $old_desc   = $trans['description'];
        $box_id     = $trans['box_id'];

        // 2. تحديث السند: المبلغ يصبح 0، الحالة ملغي، وتعديل الملاحظات
        $new_desc = "(Deleted: Amount was " . number_format(abs($old_amount), 2) . ") " . $old_desc;
        
        $updateSql = "UPDATE expense_transactions SET 
                        amount = 0, 
                        status = 'canceled', 
                        description = ? 
                      WHERE trans_id = ?";
        $pdo->prepare($updateSql)->execute([$new_desc, $trans_id]);

        // 3. إعادة المبلغ للصندوق إذا كان السند أصلاً "Paid" (موجب)
        // أما إذا كان Due (سالب) فلا يتم استرجاع شيء للصندوق لأنه لم يخصم أصلاً
        if ($old_amount > 0) {
            $updateBox = $pdo->prepare("UPDATE cash_boxes SET current_balance = current_balance + ? WHERE cashbox_id = ?");
            $updateBox->execute([$old_amount, $box_id]);
        }

        $pdo->commit();
        header("Location: expenses.php?msg=deleted");
        exit;

    } catch (Exception $e) {
        $pdo->rollBack();
        die("Error: " . $e->getMessage());
    }
}