<?php
session_start();
if (!isset($_SESSION['logged_in'])) {
    header('Location: login.php');
    exit;
}

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/helpers.php';

// 1. جلب الإحصائيات العامة
$total_customers = $pdo->query("SELECT COUNT(*) FROM customers WHERE status = 'active'")->fetchColumn();
$total_agents = $pdo->query("SELECT COUNT(*) FROM agents WHERE status = 'active'")->fetchColumn();
$active_shipments = $pdo->query("SELECT COUNT(*) FROM newshipments WHERE status NOT IN ('Cancelled', 'inactive')")->fetchColumn();

// 2. جلب الصناديق بناءً على الأسماء الصحيحة التي أرسلتها
$boxes = $pdo->query("SELECT cashbox_name, current_balance FROM cash_boxes WHERE status = 'active' ORDER BY cashbox_id ASC")->fetchAll();

// 3. جلب آخر العمليات
$recent_activities = $pdo->query("SELECT description, created_at, debit, credit FROM daily_transactions ORDER BY created_at DESC LIMIT 5")->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard | Shipping System</title>
    <link href="../assets/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../assets/font-awesome/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;600;700&display=swap');
        :root { --primary-dark: #1e2937; --accent-blue: #38bdf8; --bg-light: #f8fafc; }
        body { font-family: 'Plus Jakarta Sans', sans-serif; background: var(--bg-light); margin-left: 260px; }
        .main-content { padding: 40px; }
        .welcome-banner { background: linear-gradient(135deg, var(--primary-dark) 0%, #334155 100%); color: white; padding: 35px; border-radius: 24px; margin-bottom: 40px; box-shadow: 0 10px 15px rgba(0,0,0,0.1); }
        .stat-card { background: #fff; border-radius: 20px; padding: 24px; transition: 0.3s; display: flex; align-items: center; gap: 20px; box-shadow: 0 4px 6px rgba(0,0,0,0.05); border:none; height: 100%; }
        .stat-card:hover { transform: translateY(-5px); box-shadow: 0 12px 20px rgba(0,0,0,0.1); }
        .stat-icon { width: 60px; height: 60px; border-radius: 16px; display: flex; align-items: center; justify-content: center; font-size: 24px; flex-shrink: 0; }
        .icon-blue { background: #eff6ff; color: #3b82f6; }
        .icon-green { background: #f0fdf4; color: #22c55e; }
        .icon-purple { background: #faf5ff; color: #a855f7; }
        .icon-orange { background: #fff7ed; color: #f97316; }
        .activity-section { background: #fff; border-radius: 24px; padding: 30px; box-shadow: 0 4px 6px rgba(0,0,0,0.05); }
        .badge-debit { background: #fee2e2; color: #ef4444; border-radius: 8px; padding: 5px 10px; font-weight: 700; }
        .badge-credit { background: #dcfce7; color: #10b981; border-radius: 8px; padding: 5px 10px; font-weight: 700; }
        .fw-800 { font-weight: 800; }
    </style>
</head>
<body>

<div class="d-flex">
    <?php include 'sidebar.php'; ?>

    <div class="main-content flex-grow-1">
        <div class="welcome-banner">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1>Welcome, <?= htmlspecialchars($_SESSION['username']) ?> 👋</h1>
                    <p class="mb-0">Your shipping business at a glance.</p>
                </div>
                <span class="badge bg-white text-dark p-2 px-3 rounded-pill shadow-sm">
                    <i class="fas fa-clock text-primary me-2"></i><?= date('F j, Y') ?>
                </span>
            </div>
        </div>

        <div class="row g-4 mb-4">
            <div class="col-md-4">
                <div class="stat-card">
                    <div class="stat-icon icon-blue"><i class="fas fa-ship"></i></div>
                    <div><div class="small text-muted fw-bold">ACTIVE SHIPMENTS</div><div class="h4 mb-0 fw-800"><?= $active_shipments ?></div></div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="stat-card">
                    <div class="stat-icon icon-green"><i class="fas fa-user-friends"></i></div>
                    <div><div class="small text-muted fw-bold">TOTAL CLIENTS</div><div class="h4 mb-0 fw-800"><?= $total_customers ?></div></div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="stat-card">
                    <div class="stat-icon icon-purple"><i class="fas fa-handshake"></i></div>
                    <div><div class="small text-muted fw-bold">ACTIVE AGENTS</div><div class="h4 mb-0 fw-800"><?= $total_agents ?></div></div>
                </div>
            </div>
        </div>

        <h5 class="fw-bold mb-3 mt-5">Cash Balances / أرصدة الصناديق</h5>
        <div class="row g-4 mb-5">
            <?php foreach($boxes as $box): 
                $name = $box['cashbox_name'];
                // تمييز صندوق الدولار بالأيقونة واللون الأخضر
                $is_usd = (stripos($name, 'دولار') !== false || stripos($name, 'USD') !== false);
            ?>
            <div class="col-md-3">
                <div class="stat-card">
                    <div class="stat-icon <?= $is_usd ? 'icon-green' : 'icon-orange' ?>">
                        <i class="fas <?= $is_usd ? 'fa-dollar-sign' : 'fa-wallet' ?>"></i>
                    </div>
                    <div>
                        <div class="small text-muted fw-bold"><?= htmlspecialchars($name) ?></div>
                        <div class="h4 mb-0 fw-800"><?= number_format($box['current_balance'], 2) ?></div>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>

        <div class="activity-section">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h5 class="fw-bold m-0">Recent Transactions</h5>
                <a href="daily_transactions.php" class="btn btn-sm btn-outline-primary rounded-pill">View All</a>
            </div>
            <div class="table-responsive">
                <table class="table align-middle">
                    <thead>
                        <tr class="text-muted small">
                            <th>DESCRIPTION</th><th>DATE</th><th class="text-center">DEBIT</th><th class="text-center">CREDIT</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($recent_activities as $activity): ?>
                        <tr>
                            <td class="fw-bold"><?= htmlspecialchars($activity['description']) ?></td>
                            <td class="text-muted small"><?= date('M d, H:i', strtotime($activity['created_at'])) ?></td>
                            <td class="text-center"><?= $activity['debit'] > 0 ? '<span class="badge-debit">-$'.number_format($activity['debit'], 2).'</span>' : '-' ?></td>
                            <td class="text-center"><?= $activity['credit'] > 0 ? '<span class="badge-credit">+$'.number_format($activity['credit'], 2).'</span>' : '-' ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<script src="../assets/js/bootstrap.bundle.min.js"></script>
</body>
</html>