<?php
require_once '../src/auth.php';
protectPage();

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header('Location: currencies.php');
    exit;
}

$currency_id = (int)$_GET['id'];
$message = "";

/* ======================
   Fetch Currency
====================== */
$stmt = $pdo->prepare("
    SELECT currency_id, currency_name, currency_code
    FROM currencies
    WHERE currency_id = ?
");
$stmt->execute([$currency_id]);
$currency = $stmt->fetch();

if (!$currency) {
    die('Currency not found');
}

/* ======================
   Update Currency
====================== */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $currency_name = trim($_POST['currency_name']);
    $currency_code = trim($_POST['currency_code']);

    if ($currency_name === '' || $currency_code === '') {
        $message = "<div class='alert danger'>جميع الحقول مطلوبة</div>";
    } else {
        try {
            $update = $pdo->prepare("
                UPDATE currencies
                SET currency_name = ?, currency_code = ?
                WHERE currency_id = ?
            ");
            $update->execute([$currency_name, $currency_code, $currency_id]);

            $message = "<div class='alert success'>
                تم تحديث العملة بنجاح ✔
                <a href='currencies.php'>العودة للقائمة</a>
            </div>";

            // تحديث البيانات المعروضة
            $currency['currency_name'] = $currency_name;
            $currency['currency_code'] = $currency_code;

        } catch (PDOException $e) {
            $message = "<div class='alert danger'>خطأ: {$e->getMessage()}</div>";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>تعديل عملة</title>
    <link rel="stylesheet" href="../assets/css/currencies.css">
    <link rel="stylesheet" href="../assets/css/all.min.css">
</head>
<body>

<div class="sidebar">
    <div class="logo">نظام الشحن</div>
    <a href="currencies.php">
        <i class="fas fa-arrow-right"></i> رجوع لقائمة العملات
    </a>
</div>

<div class="main-content">
    <div class="form-container">
        <h2><i class="fas fa-edit"></i> تعديل العملة</h2>

        <?= $message ?>

        <form method="POST">

            <div class="form-group">
                <label>اسم العملة</label>
                <input type="text"
                       name="currency_name"
                       value="<?= htmlspecialchars($currency['currency_name']) ?>"
                       required>
            </div>

            <div class="form-group">
                <label>رمز العملة</label>
                <input type="text"
                       name="currency_code"
                       value="<?= htmlspecialchars($currency['currency_code']) ?>"
                       required>
            </div>

            <div class="form-actions">
                <button type="submit" class="btn-save">
                    <i class="fas fa-save"></i> تحديث
                </button>
                <a href="currencies.php" class="btn-back">إلغاء</a>
            </div>

        </form>
    </div>
</div>

</body>
</html>
