<?php
require_once '../src/auth.php';
protectPage();

$message = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $currency_name = trim($_POST['currency_name']);
    $currency_code = trim($_POST['currency_code']);

    if ($currency_name === '' || $currency_code === '') {
        $message = "<div class='alert danger'>جميع الحقول مطلوبة</div>";
    } else {
        try {
            $stmt = $pdo->prepare("
                INSERT INTO currencies (currency_name, currency_code)
                VALUES (?, ?)
            ");
            $stmt->execute([$currency_name, $currency_code]);

            $message = "<div class='alert success'>
                تم إضافة العملة بنجاح ✔
                <a href='currencies.php'>عرض العملات</a>
            </div>";
        } catch (PDOException $e) {
            $message = "<div class='alert danger'>خطأ: {$e->getMessage()}</div>";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>إضافة عملة</title>
    <link rel="stylesheet" href="../assets/css/currencies.css">
    <link rel="stylesheet" href="../assets/font-awesome/css/all.min.css">
</head>
<body>

<div class="sidebar">
    <div class="logo">نظام الشحن</div>
    <a href="currencies.php">
        <i class="fas fa-arrow-right"></i> رجوع لقائمة العملات
    </a>
</div>

<div class="main-content">
    <div class="form-container">
        <h2><i class="fas fa-coins"></i> إضافة عملة جديدة</h2>

        <?= $message ?>

        <form method="POST">

            <div class="form-group">
                <label>اسم العملة</label>
                <input type="text" name="currency_name" required placeholder="مثل: US Dollar">
            </div>

            <div class="form-group">
                <label>رمز العملة</label>
                <input type="text" name="currency_code" required placeholder="USD">
            </div>

            <div class="form-actions">
                <button type="submit" class="btn-save">
                    <i class="fas fa-save"></i> حفظ
                </button>
                <a href="currencies.php" class="btn-back">إلغاء</a>
            </div>

        </form>
    </div>
</div>

</body>
</html>
