<?php
session_start();
if (!isset($_SESSION['logged_in'])) {
    header('Location: login.php');
    exit;
}

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/helpers.php';

if (!can('currencies','view')) {
    die('Access Denied');
}

/* ======================
   Fetch Currencies
====================== */
$stmt = $pdo->query("
    SELECT currency_id, currency_name, currency_code
    FROM currencies
    ORDER BY currency_name ASC
");
$currencies = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Currencies Management</title>
<link rel="stylesheet" href="../assets/font-awesome/css/all.min.css">

<style>
body{margin:0;font-family:Inter,Arial;background:#f1f5f9}
.container{padding:28px}

.page-header{
    display:flex;justify-content:space-between;align-items:center;
    margin-bottom:20px
}
.page-header h2{margin:0;font-size:1.2rem;font-weight:800}

.btn{
    padding:8px 12px;border-radius:8px;font-size:12px;
    font-weight:700;text-decoration:none;border:none;
    cursor:pointer;display:inline-flex;align-items:center;gap:6px
}
.btn-gray{background:#334155;color:#fff}
.btn-success{background:#16a34a;color:#fff}
.btn-edit{background:#2563eb;color:#fff;padding:5px 8px}

.card{
    background:#fff;border-radius:14px;
    border:1px solid #e5e7eb;overflow:hidden
}

table{width:100%;border-collapse:collapse}
th,td{padding:12px 14px;border-bottom:1px solid #e5e7eb;font-size:13px}
th{text-align:left;background:#f8fafc;font-size:12px;font-weight:800;text-transform:uppercase}

.actions{display:flex;gap:6px}
</style>
</head>
<body>

<div class="container">

    <div class="page-header">
        <h2>💱 Currencies</h2>
        <div>
            <a href="dashboard.php" class="btn btn-gray">
                <i class="fas fa-arrow-left"></i> Back
            </a>

            <?php if (can('currencies','add')): ?>
                <a href="" class="btn btn-success">
                    <i class="fas fa-plus"></i> Add Currency
                </a>
            <?php endif; ?>
        </div>
    </div>

    <div class="card">
        <table>
            <thead>
                <tr>
                    <th>#</th>
                    <th>Currency Name</th>
                    <th>Code</th>
                    <th style="text-align:center">Actions</th>
                </tr>
            </thead>
            <tbody>
            <?php if (!$currencies): ?>
                <tr>
                    <td colspan="4" style="text-align:center;color:#6b7280;padding:30px">
                        No currencies found
                    </td>
                </tr>
            <?php else: ?>
                <?php foreach ($currencies as $i => $c): ?>
                <tr>
                    <td><?= $i+1 ?></td>
                    <td><?= htmlspecialchars($c['currency_name']) ?></td>
                    <td><b><?= htmlspecialchars($c['currency_code']) ?></b></td>
                    <td style="text-align:center">
                        <div class="actions" style="justify-content:center">
                            <?php if (can('currencies','edit')): ?>
                                <a href="currency_edit.php?id=<?= $c['currency_id'] ?>"
                                   class="btn btn-edit">
                                   <i class="fas fa-edit"></i>
                                </a>
                            <?php endif; ?>
                        </div>
                    </td>
                </tr>
                <?php endforeach; ?>
            <?php endif; ?>
            </tbody>
        </table>
    </div>

</div>

</body>
</html>
