<?php
session_start();
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/helpers.php';

if (!can('container', 'edit')) die('Access Denied');

$id = $_GET['id'] ?? 0;
$stmt = $pdo->prepare("SELECT * FROM container_types WHERE container_id = ?");
$stmt->execute([$id]);
$data = $stmt->fetch();

if (!$data) die('Type not found');

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $stmt = $pdo->prepare("UPDATE container_types SET container_type=?, description=?, status=? WHERE container_id=?");
    $stmt->execute([$_POST['container_type'], $_POST['description'], $_POST['status'], $id]);
    header("Location: container.php?msg=updated");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Edit Container Type</title>
    <link href="../assets/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-5">
            <div class="card shadow-sm border-0 rounded-4">
                <div class="card-header bg-dark text-white p-3 rounded-top-4">
                    <h5 class="mb-0">Edit: <?= htmlspecialchars($data['container_type']) ?></h5>
                </div>
                <div class="card-body p-4">
                    <form method="POST">
                        <div class="mb-3">
                            <label class="form-label fw-bold small text-muted">Type Name</label>
                            <input type="text" name="container_type" class="form-control" value="<?= htmlspecialchars($data['container_type']) ?>" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold small text-muted">Description</label>
                            <textarea name="description" class="form-control" rows="3"><?= htmlspecialchars($data['description']) ?></textarea>
                        </div>
                        <div class="mb-4">
                            <label class="form-label fw-bold small text-muted">Status</label>
                            <select name="status" class="form-select">
                                <option value="active" <?= $data['status'] == 'active' ? 'selected' : '' ?>>Active</option>
                                <option value="inactive" <?= $data['status'] == 'inactive' ? 'selected' : '' ?>>Inactive</option>
                            </select>
                        </div>
                        <div class="d-flex justify-content-between pt-3 border-top">
                            <a href="container.php" class="btn btn-light px-4">Back</a>
                            <button type="submit" class="btn btn-dark px-4">Update Type</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>