<?php
session_start();
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/helpers.php';

if (!can('container', 'add')) die('Access Denied');

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $stmt = $pdo->prepare("INSERT INTO container_types (container_type, description, status) VALUES (?, ?, ?)");
    $stmt->execute([$_POST['container_type'], $_POST['description'], $_POST['status']]);
    header("Location: container.php?msg=added");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Add Container Type</title>
    <link href="../assets/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-5">
            <div class="card shadow-sm border-0 rounded-4">
                <div class="card-header bg-primary text-white p-3 rounded-top-4">
                    <h5 class="mb-0">Create Container Category</h5>
                </div>
                <div class="card-body p-4">
                    <form method="POST">
                        <div class="mb-3">
                            <label class="form-label fw-bold small text-muted">Type Name</label>
                            <input type="text" name="container_type" class="form-control" placeholder="e.g. 20ft Dry, 40ft High Cube" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold small text-muted">Technical Description</label>
                            <textarea name="description" class="form-control" rows="3" placeholder="Dimensions, weight limits, or special features..."></textarea>
                        </div>
                        <div class="mb-4">
                            <label class="form-label fw-bold small text-muted">Usage Status</label>
                            <select name="status" class="form-select">
                                <option value="active">Active (Available for shipments)</option>
                                <option value="inactive">Inactive (Archive)</option>
                            </select>
                        </div>
                        <div class="d-flex justify-content-between pt-3 border-top">
                            <a href="container.php" class="btn btn-light px-4">Cancel</a>
                            <button type="submit" class="btn btn-primary px-4">Register Type</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>