<?php
session_start();
if (!isset($_SESSION['logged_in'])) {
    header('Location: login.php');
    exit;
}

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/helpers.php';

if (!can('container', 'view')) {
    die('Access Denied');
}

// Handle Delete
if (isset($_GET['delete'])) {
    if (!can('container', 'delete')) die('Access Denied');
    $stmt = $pdo->prepare("DELETE FROM container_types WHERE container_id = ?");
    $stmt->execute([$_GET['delete']]);
    header("Location: container.php?msg=deleted");
    exit;
}

$containers = $pdo->query("SELECT * FROM container_types ORDER BY container_id DESC")->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Container Types Management</title>
    <link href="../assets/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../assets/font-awesome/css/all.min.css">
    <style>
        :root { --primary: #334155; --accent: #6366f1; --bg: #f8fafc; }
        body { background: var(--bg); font-family: 'Inter', sans-serif; }
        .page-header { background: white; padding: 20px; border-bottom: 1px solid #e2e8f0; margin-bottom: 30px; }
        .main-card { background: white; border-radius: 12px; border: 1px solid #e2e8f0; box-shadow: 0 1px 3px rgba(0,0,0,0.1); }
        .table thead th { background: #f1f5f9; color: #475569; font-size: 11px; text-transform: uppercase; padding: 15px; }
        .type-label { font-weight: 700; color: var(--accent); }
        .status-badge { padding: 4px 10px; border-radius: 6px; font-size: 10px; font-weight: 800; }
    </style>
</head>
<body>    

<div class="page-header">
    <div class="container d-flex justify-content-between align-items-center">
        <h4 class="m-0"><i class="fas fa-boxes me-2 text-primary"></i> Container Types</h4>
        <div class="d-flex gap-2">
            <a href="dashboard.php" class="btn btn-outline-secondary btn-sm">Dashboard</a>
            <a href="container_add.php" class="btn btn-primary btn-sm px-4"><i class="fas fa-plus me-1"></i> Add New Type</a>
        </div>
    </div>
</div>

<div class="container">
    <?php if(isset($_GET['msg'])): ?>
        <div class="alert alert-success border-0 shadow-sm alert-dismissible fade show">
            Update successful!
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    

    <div class="card main-card">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead>
                    <tr>
                        <th width="80">ID</th>
                        <th>Container Type</th>
                        <th>Description</th>
                        <th>Status</th>
                        <th width="120" class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($containers as $c): ?>
                    <tr>
                        <td class="text-muted">#<?= $c['container_id'] ?></td>
                        <td><span class="type-label"><?= htmlspecialchars($c['container_type']) ?></span></td>
                        <td class="text-muted"><?= htmlspecialchars($c['description'] ?: 'No description provided') ?></td>
                        <td>
                            <span class="status-badge <?= $c['status'] == 'active' ? 'bg-success-subtle text-success' : 'bg-danger-subtle text-danger' ?>">
                                <?= strtoupper($c['status']) ?>
                            </span>
                        </td>
                        <td class="text-center">
                            <a href="container_edit.php?id=<?= $c['container_id'] ?>" class="btn btn-sm btn-light border"><i class="fas fa-edit text-primary"></i></a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    function confirmDelete(id) {
        Swal.fire({
            title: 'Delete this type?',
            text: "Existing shipments using this container type won't be deleted, but no new ones can use it.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#ef4444',
            confirmButtonText: 'Yes, delete'
        }).then((result) => {
            if (result.isConfirmed) window.location.href = 'container.php?delete=' + id;
        });
    }
</script>
</body>
</html>