<?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }

// التحقق من تسجيل الدخول
if (!isset($_SESSION['logged_in'])) {
    header('Location: login.php');
    exit;
}

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/helpers.php';

// التحقق من الصلاحيات
if (!can('settings','edit')) {
    die('Access Denied');
}

$message = '';
$error = '';

// 1. جلب البيانات (السجل رقم 1 هو الافتراضي لإعدادات الشركة)
$stmt = $pdo->query("SELECT * FROM company_settings WHERE id = 1");
$settings = $stmt->fetch();

if (!$settings) {
    // إذا لم يكن هناك سجل، نقوم بإنشاء سجل فارغ لتجنب الأخطاء
    $pdo->query("INSERT INTO company_settings (id, company_name_en) VALUES (1, 'My Company')");
    $settings = $pdo->query("SELECT * FROM company_settings WHERE id = 1")->fetch();
}

// 2. معالجة التحديث
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // تحديث النصوص
        $sql = "UPDATE company_settings SET 
                company_name_en = ?, company_name_ar = ?, 
                address_en = ?, address_ar = ?, 
                phones_en = ?, phones_ar = ?, 
                footer_text_en = ?, footer_text_ar = ?
                WHERE id = 1";
        
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            $_POST['company_name_en'], $_POST['company_name_ar'],
            $_POST['address_en'], $_POST['address_ar'],
            $_POST['phones_en'], $_POST['phones_ar'],
            $_POST['footer_text_en'], $_POST['footer_text_ar']
        ]);

        // معالجة الشعار (Logo) في المسار المحدد
        if (!empty($_FILES['logo']['name'])) {
            $target_dir  = "../assets/images/";
            $target_file = $target_dir . "logo.png"; // اسم ثابت

            // التأكد من وجود المجلد وصلاحياته
            if (!is_dir($target_dir)) {
                mkdir($target_dir, 0777, true);
            }

            // رفع الملف (سيقوم باستبدال القديم تلقائياً)
            if (move_uploaded_file($_FILES['logo']['tmp_name'], $target_file)) {
                $pdo->query("UPDATE company_settings SET logo_path = 'logo.png' WHERE id = 1");
            }
        }

        header("Location: company_settings.php?success=1");
        exit;
    } catch (PDOException $e) {
        $error = "Database Error: " . $e->getMessage();
    }
}

if (isset($_GET['success'])) $message = "Settings updated successfully!";
?>

<!DOCTYPE html>
<html lang="en" dir="ltr">
<head>
    <meta charset="UTF-8">
    <title>TMS | Company Settings</title>
    <style>
        :root { --bg:#f1f5f9; --primary:#2563eb; --border:#e2e8f0; --text:#1e293b; }
        body { margin:0; font-family:system-ui, sans-serif; background:var(--bg); color:var(--text); }
        .container { padding:30px; max-width:900px; margin:auto; }
        
        /* Header */
        .page-header { display:flex; justify-content:space-between; align-items:center; margin-bottom:25px; }
        .page-header h2 { margin:0; font-size:1.4rem; font-weight:800; }
        
        /* Card */
        .card { background:#fff; border-radius:12px; border:1px solid var(--border); padding:30px; box-shadow:0 1px 3px rgba(0,0,0,0.1); }
        .form-grid { display:grid; grid-template-columns: 1fr 1fr; gap:20px; }
        
        .section-label { grid-column:span 2; font-size:11px; font-weight:800; color:var(--primary); 
                         text-transform:uppercase; border-bottom:1px solid var(--border); padding-bottom:5px; margin-top:10px; }
        
        .form-group { display:flex; flex-direction:column; }
        label { font-size:12px; font-weight:700; color:#64748b; margin-bottom:6px; }
        input, textarea { padding:10px; border:1px solid var(--border); border-radius:8px; font-size:14px; outline:none; }
        input:focus { border-color:var(--primary); }
        textarea { height:70px; resize:none; font-family:inherit; }

        /* Logo Area */
        .logo-box { grid-column:span 2; display:flex; align-items:center; gap:20px; background:#f8fafc; padding:20px; border-radius:10px; border:1px dashed #cbd5e1; }
        .logo-box img { height:70px; background:#fff; border:1px solid var(--border); border-radius:5px; padding:5px; }
        
        /* Alerts */
        .alert { padding:12px 15px; border-radius:8px; margin-bottom:20px; font-size:13px; font-weight:600; }
        .alert-success { background:#dcfce7; color:#166534; border:1px solid #86efac; }
        .alert-danger { background:#fee2e2; color:#991b1b; border:1px solid #fca5a5; }

        .btn { padding:12px 25px; border-radius:8px; font-weight:700; cursor:pointer; border:none; text-decoration:none; font-size:14px; }
        .btn-primary { background:var(--primary); color:#fff; }
        .btn-gray { background:#fff; border:1px solid var(--border); color:var(--text); }
        
        [dir="rtl"] { text-align: right; }
    </style>
</head>
<body>

<div class="container">
    <div class="page-header">
        <h2>Company Profile Settings</h2>
        <a href="dashboard.php" class="btn btn-gray">Back</a>
    </div>

    <?php if ($message): ?> <div class="alert alert-success"><?= $message ?></div> <?php endif; ?>
    <?php if ($error): ?> <div class="alert alert-danger"><?= $error ?></div> <?php endif; ?>

    <div class="card">
        <form method="POST" enctype="multipart/form-data">
            <div class="form-grid">
                
                <div class="section-label">Identity & Branding</div>
                
                <div class="form-group">
                    <label>Company Name (EN)</label>
                    <input type="text" name="company_name_en" value="<?= htmlspecialchars($settings['company_name_en'] ?? '') ?>" required>
                </div>
                <div class="form-group">
                    <label>Company Name (AR)</label>
                    <input type="text" name="company_name_ar" value="<?= htmlspecialchars($settings['company_name_ar'] ?? '') ?>" required dir="rtl">
                </div>
<div class="logo-box">
    <?php 
        $logo_path = "../assets/images/logo.png";
        // التحقق من وجود الملف فعلياً على السيرفر
        // إذا كان موجوداً نضيف توقيت زمني لمنع التخزين المؤقت، وإذا لم يوجد نعرض صورة افتراضية
        $display_logo = file_exists($logo_path) ? $logo_path . "?v=" . time() : "../assets/no-logo.png"; 
    ?>
    <img src="<?= $display_logo ?>" alt="Logo Preview">
    <div style="flex:1">
        <label>Update Logo (PNG/JPG)</label>
        <input type="file" name="logo" accept="image/*">
        <small style="display:block; color:#94a3b8; margin-top:5px;">Static path: assets/images/logo.png</small>
    </div>
</div>

                <div class="section-label">Contact Details</div>
                
                <div class="form-group">
                    <label>Phones (EN)</label>
                    <input type="text" name="phones_en" value="<?= htmlspecialchars($settings['phones_en'] ?? '') ?>">
                </div>
                <div class="form-group">
                    <label>Phones (AR)</label>
                    <input type="text" name="phones_ar" value="<?= htmlspecialchars($settings['phones_ar'] ?? '') ?>" dir="rtl">
                </div>

                <div class="form-group">
                    <label>Address (EN)</label>
                    <textarea name="address_en"><?= htmlspecialchars($settings['address_en'] ?? '') ?></textarea>
                </div>
                <div class="form-group">
                    <label>Address (AR)</label>
                    <textarea name="address_ar" dir="rtl"><?= htmlspecialchars($settings['address_ar'] ?? '') ?></textarea>
                </div>

                <div class="section-label">Documents Footer</div>
                
                <div class="form-group">
                    <label>Footer Note (EN)</label>
                    <input type="text" name="footer_text_en" value="<?= htmlspecialchars($settings['footer_text_en'] ?? '') ?>">
                </div>
                <div class="form-group">
                    <label>Footer Note (AR)</label>
                    <input type="text" name="footer_text_ar" value="<?= htmlspecialchars($settings['footer_text_ar'] ?? '') ?>" dir="rtl">
                </div>

                <div style="grid-column:span 2; padding-top:20px; border-top:1px solid var(--border); margin-top:10px;">
                    <button type="submit" class="btn btn-primary">Update Settings</button>
                </div>
            </div>
        </form>
    </div>
</div>

</body>
</html>