<?php
session_start();
if (!isset($_SESSION['logged_in'])) {
    header('Location: login.php');
    exit;
}

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/helpers.php';

if (!can('clients','view')) {
    die('Access Denied');
}

/* Search */
$search = trim($_GET['search'] ?? '');
$where = '';
$params = [];

if ($search !== '') {
    $where = "WHERE name LIKE ? OR phone LIKE ? OR email LIKE ? OR whatsapp LIKE ?";
    $params = ["%$search%", "%$search%", "%$search%", "%$search%"];
}

$stmt = $pdo->prepare("
    SELECT customer_id, name, phone, email, whatsapp, image, status, created_at
    FROM customers
    $where
    ORDER BY customer_id DESC
");
$stmt->execute($params);
$customers = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Clients</title>

<style>
body {
    margin:0;
    font-family:'Segoe UI', Arial, sans-serif;
    background:#f4f6f8;
}
.container {
    padding:25px;
}

/* Header */
.page-header {
    display:flex;
    justify-content:space-between;
    align-items:center;
    margin-bottom:20px;
}
.page-header h2 { margin:0; }

/* Buttons */
.btn {
    padding:8px 12px;
    border-radius:4px;
    font-size:13px;
    text-decoration:none;
    border:none;
    cursor:pointer;
}
.btn-primary { background:#2563eb; color:#fff; }
.btn-success { background:#16a34a; color:#fff; }
.btn-danger  { background:#dc2626; color:#fff; }
.btn-gray    { background:#6b7280; color:#fff; }
.btn-print   { background:#0f766e; color:#fff; }

/* Search */
.search-box {
    display:flex;
    gap:10px;
    margin-bottom:15px;
}
.search-box input {
    width:280px;
    padding:8px;
}

/* Table */
.table-wrapper {
    background:#fff;
    border-radius:6px;
    box-shadow:0 2px 6px rgba(0,0,0,.08);
    overflow-x:auto;
}
table {
    width:100%;
    border-collapse:collapse;
    min-width:1100px;
}
thead {
    background:#f1f5f9;
}
th, td {
    padding:10px 12px;
    font-size:13px;
    border-bottom:1px solid #e5e7eb;
    white-space:nowrap;
}
th {
    text-align:left;
    color:#374151;
}
tr:hover {
    background:#f9fafb;
}

/* Avatar */
.avatar {
    width:40px;
    height:40px;
    border-radius:50%;
    object-fit:cover;
    border:1px solid #e5e7eb;
}

/* Status */
.badge {
    padding:4px 8px;
    border-radius:12px;
    font-size:12px;
    font-weight:600;
}
.badge-active {
    background:#dcfce7;
    color:#166534;
}
.badge-inactive {
    background:#fee2e2;
    color:#991b1b;
}

/* Actions */
.actions {
    display:flex;
    gap:6px;
}
.actions a {
    padding:6px 8px;
    border-radius:4px;
    font-size:12px;
}

/* Print */
@media print {
    body * { visibility:hidden; }
    .table-wrapper, .table-wrapper * {
        visibility:visible;
    }
    .table-wrapper {
        position:absolute;
        left:0;
        top:0;
        width:100%;
    }
}
</style>
</head>
<body>

<div class="container">

    <!-- Header -->
    <div class="page-header">
        <h2>Clients</h2>
        <div>
            <a href="dashboard.php" class="btn btn-gray">⬅ Back</a>

            <?php if (can('clients','add')): ?>
                <a href="client_add.php" class="btn btn-success">➕ Add</a>
            <?php endif; ?>

            <?php if (can('clients','print')): ?>
                <button onclick="window.print()" class="btn btn-print">🖨 Print</button>
            <?php endif; ?>
        </div>
    </div>

    <!-- Search -->
    <form method="get" class="search-box">
        <input type="text" name="search"
               placeholder="Search name, phone, email, whatsapp"
               value="<?= htmlspecialchars($search) ?>">
        <button class="btn btn-primary">Search</button>
    </form>

    <!-- Table -->
    <div class="table-wrapper">
        <table>
            <thead>
                <tr>
                    <th>#</th>
                    <th>Photo</th>
                    <th>Name</th>
                    <th>Phone</th>
                    <th>WhatsApp</th>
                    <th>Email</th>
                    <th>Status</th>
                    <th>Created</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
            <?php if (!$customers): ?>
                <tr>
                    <td colspan="9" style="text-align:center;">No clients found</td>
                </tr>
            <?php else: ?>
                <?php foreach ($customers as $i => $c): ?>
                <tr>
                    <td><?= $i + 1 ?></td>
                    <td>
                        <?php
                        $img = $c['image']
                            ? '../uploads/clients/' . $c['image']
                            : '../assets/no-avatar.png';
                        ?>
                        <img src="<?= htmlspecialchars($img) ?>" class="avatar">
                    </td>
                    <td><?= htmlspecialchars($c['name']) ?></td>
                    <td><?= htmlspecialchars($c['phone']) ?></td>
                    <td><?= htmlspecialchars($c['whatsapp']) ?></td>
                    <td><?= htmlspecialchars($c['email']) ?></td>
                  <td>
    <?php if ($c['status'] === 'active'): ?>
        <span class="badge badge-active">Active</span>
    <?php else: ?>
        <span class="badge badge-inactive">Inactive</span>
    <?php endif; ?>
</td>

                    <td><?= htmlspecialchars($c['created_at']) ?></td>
                    <td>
                        <div class="actions">
                            <?php if (can('clients','edit')): ?>
                                <a href="client_edit.php?id=<?= $c['customer_id'] ?>" class="btn btn-primary">Edit</a>
                            <?php endif; ?>

                            <?php if (can('clients','delete')): ?>
                                <a href="client_delete.php?id=<?= $c['customer_id'] ?>"
                                   class="btn btn-danger"
                                   onclick="return confirm('Delete this client?')">
                                   Delete
                                </a>
                            <?php endif; ?>
                        </div>
                    </td>
                </tr>
                <?php endforeach; ?>
            <?php endif; ?>
            </tbody>
        </table>
    </div>

</div>

</body>
</html>
