<?php
session_start();
require_once '../config/database.php';
require_once '../config/helpers.php';

if (!can('clients','delete')) {
    die('Access Denied');
}

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) {
    header("Location: clients.php");
    exit;
}

/* Soft Delete → Inactive */
$stmt = $pdo->prepare("
    UPDATE customers
    SET status = 'inactive',
        updated_at = NOW()
    WHERE customer_id = ?
");
$stmt->execute([$id]);

header("Location: clients.php");
exit;
