<?php
session_start();
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/helpers.php';

if (!can('bank', 'edit')) die('Access Denied');

$id = $_GET['id'] ?? 0;
$stmt = $pdo->prepare("SELECT * FROM bank_accounts WHERE bank_id = ?");
$stmt->execute([$id]);
$data = $stmt->fetch();

if (!$data) die('Account not found');

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $stmt = $pdo->prepare("UPDATE bank_accounts SET bank_name_ar=?, account_number=?, currency=?, is_active=? WHERE bank_id=?");
    $stmt->execute([$_POST['bank_name_ar'], $_POST['account_number'], $_POST['currency'], $_POST['is_active'], $id]);
    header("Location: bank.php?msg=updated");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Edit Bank Account</title>
    <link href="../assets/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-5">
            <div class="card shadow border-0 rounded-4">
                <div class="card-header bg-dark text-white p-4">
                    <h5 class="mb-0">Edit Account: <?= htmlspecialchars($data['account_number']) ?></h5>
                </div>
                <div class="card-body p-4">
                    <form method="POST">
                        <div class="mb-3">
                            <label class="form-label fw-bold small text-secondary">Bank Name (Arabic)</label>
                            <input type="text" name="bank_name_ar" class="form-control form-control-lg" dir="rtl" value="<?= htmlspecialchars($data['bank_name_ar']) ?>" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold small text-secondary">Account Number</label>
                            <input type="text" name="account_number" class="form-control" value="<?= htmlspecialchars($data['account_number']) ?>" required>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold small text-secondary">Currency</label>
                                <select name="currency" class="form-select">
                                    <option value="USD" <?= $data['currency'] == 'USD' ? 'selected' : '' ?>>USD</option>
                                    <option value="YER" <?= $data['currency'] == 'YER' ? 'selected' : '' ?>>YER</option>
                                    <option value="SAR" <?= $data['currency'] == 'SAR' ? 'selected' : '' ?>>SAR</option>
                                </select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold small text-secondary">Status</label>
                                <select name="is_active" class="form-select">
                                    <option value="1" <?= $data['is_active'] == 1 ? 'selected' : '' ?>>Active</option>
                                    <option value="0" <?= $data['is_active'] == 0 ? 'selected' : '' ?>>Inactive</option>
                                </select>
                            </div>
                        </div>
                        <div class="d-flex justify-content-between pt-4">
                            <a href="bank.php" class="btn btn-light px-4">Cancel</a>
                            <button type="submit" class="btn btn-dark px-5">Update Account</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>