<?php
session_start();
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/helpers.php';

if (!can('bank', 'add')) die('Access Denied');

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $stmt = $pdo->prepare("INSERT INTO bank_accounts (bank_name_ar, account_number, currency, is_active) VALUES (?, ?, ?, ?)");
    $stmt->execute([$_POST['bank_name_ar'], $_POST['account_number'], $_POST['currency'], $_POST['is_active']]);
    header("Location: bank.php?msg=added");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Add Bank Account</title>
    <link href="../assets/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-5">
            <div class="card shadow border-0 rounded-4">
                <div class="card-header bg-primary text-white p-4">
                    <h5 class="mb-0">New Bank Account Details</h5>
                </div>
                <div class="card-body p-4">
                    <form method="POST">
                        <div class="mb-3">
                            <label class="form-label fw-bold small text-secondary">Bank Name (Arabic)</label>
                            <input type="text" name="bank_name_ar" class="form-control form-control-lg" dir="rtl" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold small text-secondary">Account Number / IBAN</label>
                            <input type="text" name="account_number" class="form-control" required>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold small text-secondary">Currency</label>
                                <select name="currency" class="form-select">
                                    <option value="USD">USD - Dollar</option>
                                    <option value="YER">YER - Rial</option>
                                    <option value="SAR">SAR - Riyal</option>
                                    <option value="EUR">EUR - Euro</option>
                                </select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold small text-secondary">Account Status</label>
                                <select name="is_active" class="form-select">
                                    <option value="1">Active</option>
                                    <option value="0">Inactive</option>
                                </select>
                            </div>
                        </div>
                        <div class="d-flex justify-content-between pt-4">
                            <a href="bank.php" class="btn btn-light px-4">Back</a>
                            <button type="submit" class="btn btn-primary px-5">Save Account</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>