<?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['logged_in'])) {
    header('Location: login.php');
    exit;
}

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/helpers.php';

// Permissions Check
if (!can('bank_accounts','view')) {
    die('Access Denied');
}

/* Search Logic */
$search = trim($_GET['search'] ?? '');
$where = '';
$params = [];

if ($search !== '') {
    $where = "WHERE bank_name_ar LIKE ? OR account_number LIKE ? OR currency LIKE ?";
    $params = ["%$search%", "%$search%", "%$search%"];
}

$stmt = $pdo->prepare("
    SELECT bank_id, bank_name_ar, account_number, currency, is_active 
    FROM bank_accounts
    $where
    ORDER BY bank_id DESC
");
$stmt->execute($params);
$accounts = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Bank Accounts</title>
<style>
    body { margin:0; font-family:'Segoe UI', Arial, sans-serif; background:#f4f6f8; }
    .container { padding:25px; }
    .page-header { display:flex; justify-content:space-between; align-items:center; margin-bottom:20px; }
    .page-header h2 { margin:0; color:#1e293b; }
    
    /* Buttons */
    .btn { padding:8px 14px; border-radius:4px; font-size:13px; text-decoration:none; border:none; cursor:pointer; display:inline-flex; align-items:center; gap:5px; }
    .btn-primary { background:#2563eb; color:#fff; }
    .btn-success { background:#16a34a; color:#fff; }
    .btn-danger  { background:#dc2626; color:#fff; }
    .btn-gray    { background:#64748b; color:#fff; }
    
    /* Search Box */
    .search-box { display:flex; gap:10px; margin-bottom:15px; }
    .search-box input { width:320px; padding:8px 12px; border:1px solid #cbd5e1; border-radius:4px; }

    /* Table Design */
    .table-wrapper { background:#fff; border-radius:8px; box-shadow:0 2px 10px rgba(0,0,0,.05); overflow:hidden; }
    table { width:100%; border-collapse:collapse; }
    thead { background:#f8fafc; }
    th, td { padding:12px 15px; font-size:13px; border-bottom:1px solid #e2e8f0; text-align:left; }
    th { color:#475569; text-transform:uppercase; font-size:11px; letter-spacing:0.5px; }
    tr:hover { background:#f1f5f9; }
    code { background:#f1f5f9; padding:2px 5px; border-radius:4px; color:#e11d48; font-family:monospace; font-size:13px; }

    /* Badges */
    .badge { padding:4px 10px; border-radius:12px; font-size:11px; font-weight:700; text-transform:uppercase; }
    .badge-active { background:#dcfce7; color:#166534; }
    .badge-inactive { background:#fee2e2; color:#991b1b; }
    .currency-tag { font-weight:800; color:#2563eb; }

    .actions { display:flex; gap:6px; }
</style>
</head>
<body>

<div class="container">
    <div class="page-header">
        <h2>Bank Accounts</h2>
        <div>
            <a href="dashboard.php" class="btn btn-gray">⬅ Back</a>
            <?php if (can('bank_accounts','add')): ?>
                <a href="bank_account_add.php" class="btn btn-success">➕ Add Account</a>
            <?php endif; ?>
        </div>
    </div>

    <form method="get" class="search-box">
        <input type="text" name="search" placeholder="Search Bank, Account No, or Currency..." value="<?= htmlspecialchars($search) ?>">
        <button class="btn btn-primary">Search</button>
    </form>

    <div class="table-wrapper">
        <table>
            <thead>
                <tr>
                    <th>#</th>
                    <th>Bank Name</th>
                    <th>Account Number</th>
                    <th>Currency</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!$accounts): ?>
                    <tr><td colspan="6" style="text-align:center; padding:30px; color:#94a3b8;">No bank accounts found.</td></tr>
                <?php else: foreach ($accounts as $i => $acc): ?>
                    <tr>
                        <td><?= $i + 1 ?></td>
                        <td style="font-weight:600;"><?= htmlspecialchars($acc['bank_name_ar']) ?></td>
                        <td><code><?= htmlspecialchars($acc['account_number']) ?></code></td>
                        <td class="currency-tag"><?= htmlspecialchars($acc['currency']) ?></td>
                        <td>
                            <?php if ($acc['is_active']): ?>
                                <span class="badge badge-active">Active</span>
                            <?php else: ?>
                                <span class="badge badge-inactive">Inactive</span>
                            <?php endif; ?>
                        </td>
                        <td class="actions">
                            <?php if (can('bank_accounts','edit')): ?>
                                <a href="bank_account_edit.php?id=<?= $acc['bank_id'] ?>" class="btn btn-primary" style="padding:4px 8px;">Edit</a>
                            <?php endif; ?>
                            
                            <?php if (can('bank_accounts','delete')): ?>
                                <a href="bank_account_delete.php?id=<?= $acc['bank_id'] ?>" 
                                   class="btn btn-danger" style="padding:4px 8px;"
                                   onclick="return confirm('Are you sure you want to delete this account?')">Delete</a>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; endif; ?>
            </tbody>
        </table>
    </div>
</div>

</body>
</html>