<?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/helpers.php';

// Permissions Check
if (!can('bank_accounts','edit')) {
    die('Access Denied');
}

$id = $_GET['id'] ?? 0;

// Fetch current data
$stmt = $pdo->prepare("SELECT * FROM bank_accounts WHERE bank_id = ?");
$stmt->execute([$id]);
$account = $stmt->fetch();

if (!$account) {
    die('Account not found');
}

// Handle Update
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $stmt = $pdo->prepare("UPDATE bank_accounts SET bank_name_ar = ?, account_number = ?, currency = ?, is_active = ? WHERE bank_id = ?");
        $stmt->execute([
            $_POST['bank_name_ar'],
            $_POST['account_number'],
            $_POST['currency'],
            isset($_POST['is_active']) ? 1 : 0,
            $id
        ]);
        header("Location: bank_accounts.php?updated=1");
        exit;
    } catch (PDOException $e) {
        $error = "Error: " . $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Edit Bank Account</title>
    <style>
        body { font-family: 'Segoe UI', sans-serif; background:#f4f6f8; display:flex; justify-content:center; padding-top:50px; }
        .card { background:#fff; padding:30px; border-radius:12px; box-shadow:0 4px 20px rgba(0,0,0,0.1); width:450px; }
        .form-group { margin-bottom:15px; }
        label { display:block; font-size:12px; font-weight:700; color:#475569; margin-bottom:5px; }
        input, select { width:100%; padding:10px; border:1px solid #cbd5e1; border-radius:6px; box-sizing:border-box; }
        .btn-update { background:#2563eb; color:#fff; width:100%; padding:12px; border:none; border-radius:6px; font-weight:700; cursor:pointer; margin-top:10px; }
        .alert-error { background:#fee2e2; color:#b91c1c; padding:10px; border-radius:6px; margin-bottom:15px; font-size:13px; }
    </style>
</head>
<body>
    <div class="card">
        <h2 style="margin-top:0; color:#1e293b;">Edit Account</h2>
        
        <?php if (isset($error)): ?>
            <div class="alert-error"><?= $error ?></div>
        <?php endif; ?>

        <form method="POST">
            <div class="form-group">
                <label>Bank Name</label>
                <input type="text" name="bank_name_ar" required value="<?= htmlspecialchars($account['bank_name_ar']) ?>">
            </div>
            <div class="form-group">
                <label>Account Number (IBAN)</label>
                <input type="text" name="account_number" required value="<?= htmlspecialchars($account['account_number']) ?>">
            </div>
            <div class="form-group">
                <label>Currency</label>
                <select name="currency">
                    <?php 
                    $currencies = ['USD', 'EUR', 'QAR', 'TRY', 'YER', 'SAR'];
                    foreach($currencies as $curr): 
                    ?>
                        <option value="<?= $curr ?>" <?= ($account['currency'] == $curr) ? 'selected' : '' ?>><?= $curr ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="form-group">
                <label>
                    <input type="checkbox" name="is_active" <?= $account['is_active'] ? 'checked' : '' ?>> 
                    Active Status
                </label>
            </div>
            <button type="submit" class="btn-update">Update Account</button>
            <a href="bank_accounts.php" style="display:block; text-align:center; margin-top:15px; color:#64748b; text-decoration:none; font-size:13px;">Cancel Changes</a>
        </form>
    </div>
</body>
</html>