<?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/helpers.php';

if (!can('bank_accounts','add')) { die('Access Denied'); }

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $stmt = $pdo->prepare("INSERT INTO bank_accounts (bank_name_ar, account_number, currency, is_active) VALUES (?, ?, ?, ?)");
    $stmt->execute([
        $_POST['bank_name_ar'],
        $_POST['account_number'],
        $_POST['currency'],
        isset($_POST['is_active']) ? 1 : 0
    ]);
    header("Location: bank_accounts.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Add Bank Account</title>
    <style>
        body { font-family: 'Segoe UI', sans-serif; background:#f4f6f8; display:flex; justify-content:center; padding-top:50px; }
        .card { background:#fff; padding:30px; border-radius:12px; box-shadow:0 4px 20px rgba(0,0,0,0.1); width:450px; }
        .form-group { margin-bottom:15px; }
        label { display:block; font-size:12px; font-weight:700; color:#475569; margin-bottom:5px; }
        input, select { width:100%; padding:10px; border:1px solid #cbd5e1; border-radius:6px; box-sizing:border-box; }
        .btn-save { background:#16a34a; color:#fff; width:100%; padding:12px; border:none; border-radius:6px; font-weight:700; cursor:pointer; margin-top:10px; }
    </style>
</head>
<body>
    <div class="card">
        <h2 style="margin-top:0;">Add New Account</h2>
        <form method="POST">
            <div class="form-group">
                <label>Bank Name</label>
                <input type="text" name="bank_name_ar" required placeholder="e.g., Qatar National Bank">
            </div>
            <div class="form-group">
                <label>Account Number (IBAN)</label>
                <input type="text" name="account_number" required placeholder="Enter account number">
            </div>
            <div class="form-group">
                <label>Currency</label>
                <select name="currency">
                    <option value="USD">USD - US Dollar</option>
                    <option value="EUR">EUR - Euro</option>
                    <option value="QAR">QAR - Qatari Rial</option>
                    <option value="TRY">TRY - Turkish Lira</option>
                </select>
            </div>
            <div class="form-group">
                <label><input type="checkbox" name="is_active" checked> Mark as Active</label>
            </div>
            <button type="submit" class="btn-save">Save Bank Account</button>
            <a href="bank_accounts.php" style="display:block; text-align:center; margin-top:15px; color:#64748b; text-decoration:none; font-size:13px;">Cancel and Go Back</a>
        </form>
    </div>
</body>
</html>