<?php
session_start();
if (!isset($_SESSION['logged_in'])) {
    header('Location: login.php');
    exit;
}

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/helpers.php';

if (!can('bank', 'view')) {
    die('Access Denied');
}

// Handle Delete
if (isset($_GET['delete'])) {
    if (!can('bank', 'delete')) die('Access Denied');
    $stmt = $pdo->prepare("DELETE FROM bank_accounts WHERE bank_id = ?");
    $stmt->execute([$_GET['delete']]);
    header("Location: bank.php?msg=deleted");
    exit;
}

$banks = $pdo->query("SELECT * FROM bank_accounts ORDER BY bank_id DESC")->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Bank Accounts Management</title>
    <link href="../assets/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../assets/font-awesome/css/all.min.css">
    <style>
        :root { --primary: #0f172a; --success: #10b981; --bg: #f1f5f9; }
        body { background: var(--bg); font-family: 'Inter', sans-serif; color: #334155; }
        .page-header { background: white; padding: 25px 0; border-bottom: 1px solid #e2e8f0; margin-bottom: 30px; }
        .bank-card { background: white; border-radius: 12px; border: 1px solid #e2e8f0; box-shadow: 0 4px 6px -1px rgba(0,0,0,0.05); }
        .table thead th { background: #f8fafc; color: #64748b; font-size: 11px; text-transform: uppercase; padding: 15px; border-bottom: 2px solid #edf2f7; }
        .currency-badge { background: #eff6ff; color: #1d4ed8; padding: 4px 10px; border-radius: 6px; font-weight: 700; font-size: 12px; }
        .status-pill { width: 10px; height: 10px; border-radius: 50%; display: inline-block; margin-right: 5px; }
        .bg-active { background: var(--success); box-shadow: 0 0 8px rgba(16, 185, 129, 0.4); }
        .bg-inactive { background: #94a3b8; }
    </style>
</head>
<body>

<div class="page-header">
    <div class="container d-flex justify-content-between align-items-center">
        <div>
            <h4 class="m-0 fw-bold"><i class="fas fa-university me-2 text-primary"></i> Bank Accounts</h4>
            <small class="text-muted">Manage company bank details and balances</small>
        </div>
        <div class="d-flex gap-2">
            <a href="dashboard.php" class="btn btn-outline-secondary btn-sm">Dashboard</a>
            <a href="bank_add.php" class="btn btn-primary btn-sm px-4"><i class="fas fa-plus me-1"></i> New Account</a>
        </div>
    </div>
</div>

<div class="container">
    <?php if(isset($_GET['msg'])): ?>
        <div class="alert alert-success border-0 shadow-sm d-flex align-items-center">
            <i class="fas fa-check-circle me-2"></i> Action processed successfully!
        </div>
    <?php endif; ?>

    <div class="card bank-card">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead>
                    <tr>
                        <th width="80">ID</th>
                        <th>Bank Name (Arabic)</th>
                        <th>Account Number</th>
                        <th>Currency</th>
                        <th>Status</th>
                        <th width="150" class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($banks as $b): ?>
                    <tr>
                        <td class="text-muted">#<?= $b['bank_id'] ?></td>
                        <td><strong class="text-primary"><?= htmlspecialchars($b['bank_name_ar']) ?></strong></td>
                        <td><code class="text-dark fw-bold"><?= htmlspecialchars($b['account_number']) ?></code></td>
                        <td><span class="currency-badge"><?= $b['currency'] ?></span></td>
                        <td>
                            <span class="status-pill <?= $b['is_active'] ? 'bg-active' : 'bg-inactive' ?>"></span>
                            <small class="fw-bold"><?= $b['is_active'] ? 'Active' : 'Inactive' ?></small>
                        </td>
                        <td class="text-center">
                            <a href="bank_edit.php?id=<?= $b['bank_id'] ?>" class="btn btn-sm btn-light border"><i class="fas fa-edit text-primary"></i></a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    function confirmDelete(id) {
        Swal.fire({
            title: 'Close this account?',
            text: "This will remove the bank account from the active list.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#ef4444',
            confirmButtonText: 'Yes, Delete'
        }).then((result) => {
            if (result.isConfirmed) window.location.href = 'bank.php?delete=' + id;
        });
    }
</script>
</body>
</html>