<?php
session_start();
require_once '../config/database.php';
require_once '../config/helpers.php';

if (!can('agents','print')) {
    die('Access Denied');
}

$stmt = $pdo->query("
    SELECT name, country, phone, whatsapp, email, status, created_at
    FROM agents
    ORDER BY name ASC
");
$agents = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Agents List</title>

<style>
body {
    font-family: Arial, sans-serif;
    font-size:13px;
    color:#000;
}
h2 {
    text-align:center;
    margin-bottom:20px;
}
table {
    width:100%;
    border-collapse:collapse;
}
th, td {
    border:1px solid #000;
    padding:6px 8px;
    text-align:left;
}
th {
    background:#f0f0f0;
}
.status-active {
    font-weight:bold;
    color:green;
}
.status-inactive {
    font-weight:bold;
    color:red;
}
.footer {
    margin-top:30px;
    font-size:11px;
    text-align:right;
}
@media print {
    button { display:none; }
}
</style>
</head>

<body onload="window.print()">

<h2>Agents List</h2>

<table>
    <thead>
        <tr>
            <th>#</th>
            <th>Name</th>
            <th>Country</th>
            <th>Phone</th>
            <th>WhatsApp</th>
            <th>Email</th>
            <th>Status</th>
            <th>Created</th>
        </tr>
    </thead>
    <tbody>
    <?php if (!$agents): ?>
        <tr>
            <td colspan="8" style="text-align:center;">No agents found</td>
        </tr>
    <?php else: ?>
        <?php foreach ($agents as $i => $a): ?>
        <tr>
            <td><?= $i + 1 ?></td>
            <td><?= htmlspecialchars($a['name']) ?></td>
            <td><?= htmlspecialchars($a['country']) ?></td>
            <td><?= htmlspecialchars($a['phone']) ?></td>
            <td><?= htmlspecialchars($a['whatsapp']) ?></td>
            <td><?= htmlspecialchars($a['email']) ?></td>
            <td>
                <?php if ($a['status'] === 'active'): ?>
                    <span class="status-active">Active</span>
                <?php else: ?>
                    <span class="status-inactive">Inactive</span>
                <?php endif; ?>
            </td>
            <td><?= htmlspecialchars($a['created_at']) ?></td>
        </tr>
        <?php endforeach; ?>
    <?php endif; ?>
    </tbody>
</table>

<div class="footer">
    Printed on: <?= date('Y-m-d H:i') ?>
</div>

</body>
</html>
