<?php
require_once '../src/auth.php';
protectPage();

$message = "";

// معالجة البيانات عند إرسال النموذج
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name     = $_POST['name'];
    $phone    = $_POST['phone'];
    $email    = $_POST['email'];
    $whatsapp = $_POST['whatsapp'];
    $address  = $_POST['address'];
    $notes    = $_POST['notes'];
    
    // التعامل مع الحالة (Checkbox)
    // إذا كان مؤشر عليه سيرسل القيمة 'active'، وإذا لم يؤشر لن يرسل شيئاً فنضع 'inactive'
    $status   = isset($_POST['status']) ? 'active' : 'inactive';

    // معالجة رفع الصورة
    $image_name = "default.png"; // القيمة الافتراضية
    if (isset($_FILES['image']) && $_FILES['image']['error'] == 0) {
        $target_dir = "../uploads/customers/";
        // إنشاء المجلد إذا لم يكن موجوداً
        if (!file_exists($target_dir)) { mkdir($target_dir, 0777, true); }
        
        $file_ext = pathinfo($_FILES["image"]["name"], PATHINFO_EXTENSION);
        $image_name = time() . "_" . uniqid() . "." . $file_ext; // اسم فريد للصورة
        $target_file = $target_dir . $image_name;

        move_uploaded_file($_FILES["image"]["tmp_name"], $target_file);
    }

    try {
        $sql = "INSERT INTO customers (`name`, `phone`, `email`, `whatsapp`, `address`, `notes`, `status`, `image`, `created_at`) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, NOW())";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$name, $phone, $email, $whatsapp, $address, $notes, $status, $image_name]);
        
        $message = "<div class='alert success'>تم إضافة العميل بنجاح! <a href='customers_list.php'>عرض القائمة</a></div>";
    } catch (PDOException $e) {
        $message = "<div class='alert danger'>خطأ في الإضافة: " . $e->getMessage() . "</div>";
    }
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>إضافة عميل | نظام الملاحة</title>
    <link rel="stylesheet" href="../assets/css/all.min.css">
    <style>
        :root { --sidebar-width: 260px; --primary-color: #2c3e50; --accent-color: #3498db; }
        body { font-family: 'Segoe UI', sans-serif; margin: 0; display: flex; background: #f4f7f6; }
        .sidebar { width: var(--sidebar-width); background: var(--primary-color); height: 100vh; color: white; position: fixed; right: 0; }
        .main-content { margin-right: var(--sidebar-width); flex: 1; padding: 40px; }
        .form-container { background: white; padding: 30px; border-radius: 10px; box-shadow: 0 5px 15px rgba(0,0,0,0.1); max-width: 800px; margin: auto; }
        .form-group { margin-bottom: 15px; }
        label { display: block; margin-bottom: 5px; font-weight: bold; color: #34495e; }
        input[type="text"], input[type="email"], input[type="file"], textarea { 
            width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 5px; box-sizing: border-box; 
        }

        /* تنسيق زر الحالة (التبديل) */
        .switch { position: relative; display: inline-block; width: 60px; height: 30px; }
        .switch input { opacity: 0; width: 0; height: 0; }
        .slider { position: absolute; cursor: pointer; top: 0; left: 0; right: 0; bottom: 0; background-color: #ccc; transition: .4s; border-radius: 34px; }
        .slider:before { position: absolute; content: ""; height: 22px; width: 22px; left: 4px; bottom: 4px; background-color: white; transition: .4s; border-radius: 50%; }
        input:checked + .slider { background-color: #27ae60; }
        input:checked + .slider:before { transform: translateX(30px); }
        .status-label { display: inline-block; vertical-align: top; margin-right: 10px; font-weight: bold; }

        .btn-save { background: #27ae60; color: white; padding: 12px 25px; border: none; border-radius: 5px; cursor: pointer; font-size: 1rem; }
        .btn-back { background: #95a5a6; color: white; text-decoration: none; padding: 12px 25px; border-radius: 5px; display: inline-block; margin-right: 10px; }
        .alert { padding: 15px; border-radius: 5px; margin-bottom: 20px; }
        .success { background: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
        .danger { background: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
        .grid-2 { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; }
    </style>
</head>
<body>

    <div class="sidebar">
        <div style="padding: 20px; text-align: center; background: #1a252f;">نظام الملاحة</div>
        <a href="customers_list.php" style="display:block; padding:15px; color:white; text-decoration:none;"><i class="fas fa-arrow-right"></i> رجوع للقائمة</a>
    </div>

    <div class="main-content">
        <div class="form-container">
            <h2><i class="fas fa-user-plus"></i> إضافة عميل جديد</h2>
            <?php echo $message; ?>

            <form method="POST" enctype="multipart/form-data">
                <div class="form-group">
                    <label>اسم العميل بالكامل</label>
                    <input type="text" name="name" required placeholder="أدخل اسم العميل">
                </div>

                <div class="grid-2">
                    <div class="form-group">
                        <label>صورة العميل (اختيار من الجهاز)</label>
                        <input type="file" name="image" accept="image/*">
                    </div>
                    <div class="form-group">
                        <label>البريد الإلكتروني</label>
                        <input type="email" name="email">
                    </div>
                </div>

                <div class="grid-2">
                    <div class="form-group">
                        <label>رقم الهاتف</label>
                        <input type="text" name="phone" required placeholder="967...">
                    </div>
                    <div class="form-group">
                        <label>رقم الواتساب</label>
                        <input type="text" name="whatsapp" placeholder="967...">
                    </div>
                </div>

                <div class="form-group">
                    <label>العنوان</label>
                    <input type="text" name="address" placeholder="المدينة - الشارع">
                </div>

                <div class="form-group">
                    <label style="display: block; margin-bottom: 10px;">حالة العميل (فعال / غير فعال)</label>
                    <label class="switch">
                        <input type="checkbox" name="status" checked>
                        <span class="slider"></span>
                    </label>
                    <span class="status-label">الحساب نشط</span>
                </div>

                <div class="form-group">
                    <label>ملاحظات إضافية</label>
                    <textarea name="notes" rows="3"></textarea>
                </div>

                <div style="margin-top: 20px;">
                    <button type="submit" class="btn-save"><i class="fas fa-save"></i> حفظ البيانات</button>
                    <a href="customers_list.php" class="btn-back">إلغاء</a>
                </div>
            </form>
        </div>
    </div>

</body>
</html>