<?php
// session_start();  // غير مطلوب مؤقتًا

require_once __DIR__ . '/../config/database.php';

$message = '';
$error   = '';

/* جلب الأدوار */
$rolesStmt = $pdo->query("SELECT role_id, role_name FROM roles");
$roles = $rolesStmt->fetchAll();

/* عند إرسال النموذج */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    $role_id  = $_POST['role_id'] ?? '';

    if ($username === '' || $password === '' || $role_id === '') {
        $error = 'All fields are required.';
    } else {

        /* تشفير كلمة المرور */
        $hashedPassword = password_hash($password, PASSWORD_DEFAULT);

        try {
            $stmt = $pdo->prepare("
                INSERT INTO users (username, password, role_id)
                VALUES (?, ?, ?)
            ");
            $stmt->execute([$username, $hashedPassword, $role_id]);

            $message = 'User added successfully.';
        } catch (PDOException $e) {
            $error = 'Username already exists.';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Add User | Shipping System</title>
    <style>
        body { font-family: Arial; background:#f4f6f8; }
        .box {
            width:420px;
            margin:80px auto;
            background:#fff;
            padding:25px;
            border-radius:6px;
            box-shadow:0 0 10px rgba(0,0,0,.1);
        }
        h2 { text-align:center; }
        input, select {
            width:100%;
            padding:10px;
            margin:10px 0;
        }
        button {
            width:100%;
            padding:10px;
            background:#28a745;
            color:#fff;
            border:none;
            cursor:pointer;
        }
        .error {
            background:#f8d7da;
            color:#721c24;
            padding:10px;
            margin-bottom:10px;
            border-radius:4px;
        }
        .success {
            background:#d4edda;
            color:#155724;
            padding:10px;
            margin-bottom:10px;
            border-radius:4px;
        }
        a {
            display:block;
            text-align:center;
            margin-top:15px;
        }
    </style>
</head>
<body>

<div class="box">
    <h2>Add User</h2>

    <?php if ($error): ?>
        <div class="error"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <?php if ($message): ?>
        <div class="success"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>

    <form method="post">
        <input type="text" name="username" placeholder="Username" required>
        <input type="password" name="password" placeholder="Password" required>

        <select name="role_id" required>
            <option value="">-- Select Role --</option>
            <?php foreach ($roles as $role): ?>
                <option value="<?= $role['role_id'] ?>">
                    <?= htmlspecialchars($role['role_name']) ?>
                </option>
            <?php endforeach; ?>
        </select>

        <button type="submit">Add User</button>
    </form>

    <a href="login.php">Go to Login</a>
</div>

</body>
</html>
