-- Database Backup
-- Generated: 2026-01-03 20:07:46
SET FOREIGN_KEY_CHECKS=0;

DROP TABLE IF EXISTS `account_balances`;
CREATE TABLE `account_balances` (
  `balance_id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type` enum('Customer','Agent') NOT NULL,
  `reference_id` int(11) NOT NULL,
  `currency_id` int(11) NOT NULL,
  `current_balance` decimal(15,2) DEFAULT 0.00,
  PRIMARY KEY (`balance_id`),
  UNIQUE KEY `account_type` (`account_type`,`reference_id`,`currency_id`),
  KEY `currency_id` (`currency_id`),
  CONSTRAINT `account_balances_ibfk_1` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`currency_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `agent_transactions`;
CREATE TABLE `agent_transactions` (
  `trans_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `agent_id` int(10) unsigned NOT NULL COMMENT 'رقم الوكيل',
  `debit` decimal(14,2) DEFAULT 0.00 COMMENT 'عليه',
  `credit` decimal(14,2) DEFAULT 0.00 COMMENT 'له',
  `trans_date` date NOT NULL COMMENT 'تاريخ الحركة',
  `description` varchar(255) DEFAULT NULL COMMENT 'البيان',
  `user_id` int(10) unsigned NOT NULL COMMENT 'رقم المستخدم',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`trans_id`),
  KEY `agent_id` (`agent_id`),
  KEY `trans_date` (`trans_date`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `agent_transactions` VALUES ('7', '2', '0.00', '100.00', '2026-01-03', 'B/L: 777sds55454 | Containers: 2 | Shipment ID: 12', '1', '2026-01-03 20:50:12');
INSERT INTO `agent_transactions` VALUES ('8', '1', '0.00', '800.00', '2026-01-03', 'B/L: 777sds55454555 | Containers: 1 | Shipment ID: 13', '1', '2026-01-03 21:08:00');
INSERT INTO `agent_transactions` VALUES ('9', '2', '100.00', '0.00', '2026-01-03', 'Payment Made - Voucher #1001 (تتا)', '1', '2026-01-03 21:37:50');
INSERT INTO `agent_transactions` VALUES ('10', '2', '100.00', '0.00', '2026-01-03', 'CANCELLED: Shipment ID: 12 | B/L: 777sds55454', '1', '2026-01-03 21:48:42');
INSERT INTO `agent_transactions` VALUES ('11', '1', '100.00', '0.00', '2026-01-03', 'Payment Made - Voucher #1002 (ااا)', '1', '2026-01-03 22:07:14');
INSERT INTO `agent_transactions` VALUES ('12', '2', '0.00', '100.00', '2026-01-03', 'Void Voucher #1001', '1', '2026-01-03 22:07:18');

DROP TABLE IF EXISTS `agents`;
CREATE TABLE `agents` (
  `agent_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `country` varchar(50) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `email` varchar(150) DEFAULT NULL,
  `whatsapp` varchar(30) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `status` enum('active','inactive') DEFAULT 'active',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`agent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `agents` VALUES ('1', 'China Global Shipping Agent', 'China', '+86 21 5555 8888', 'info@chinaglobalshipping.com', '+86 138 0000 0000', 'Chinese freight forwarding and shipping agent', '1767253113_WhatsApp Image 2025-12-26 at 11.23.37 AM.jpeg', 'active', '2026-01-01 10:38:33', '2026-01-03 06:20:34');
INSERT INTO `agents` VALUES ('2', 'Shanghai Freight Solutions', 'China', '+86 21 6666 1001', 'contact@shanghaifreight.com', '+86 138 1111 1001', 'Freight forwarding agent based in Shanghai', NULL, 'active', '2026-01-03 06:21:02', NULL);
INSERT INTO `agents` VALUES ('3', 'Shenzhen Ocean Logistics', 'China', '+86 755 6666 1002', 'info@shenzhenocean.com', '+86 138 1111 1002', 'Sea freight and logistics services from Shenzhen', NULL, 'active', '2026-01-03 06:21:02', NULL);
INSERT INTO `agents` VALUES ('4', 'Ningbo Port Shipping Agent', 'China', '+86 574 6666 1003', 'sales@ningboshipping.com', '+86 138 1111 1003', 'Shipping agent operating at Ningbo-Zhoushan Port', NULL, 'active', '2026-01-03 06:21:02', NULL);
INSERT INTO `agents` VALUES ('5', 'Guangzhou Cargo Services', 'China', '+86 20 6666 1004', 'support@guangzhoucargo.com', '+86 138 1111 1004', 'Cargo handling and freight forwarding in Guangzhou', NULL, 'active', '2026-01-03 06:21:02', NULL);
INSERT INTO `agents` VALUES ('6', 'Tianjin International Shipping', 'China', '+86 22 6666 1005', 'info@tianjinshipping.com', '+86 138 1111 1005', 'International shipping agent at Tianjin Port', NULL, 'active', '2026-01-03 06:21:02', NULL);

DROP TABLE IF EXISTS `bank_accounts`;
CREATE TABLE `bank_accounts` (
  `bank_id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_name_ar` varchar(255) NOT NULL,
  `account_number` varchar(100) NOT NULL,
  `currency` varchar(50) DEFAULT 'USD/YR',
  `is_active` tinyint(1) DEFAULT 1,
  PRIMARY KEY (`bank_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
INSERT INTO `bank_accounts` VALUES ('1', 'كريمي للصرافة', '30842037', 'USD / YR', '1');
INSERT INTO `bank_accounts` VALUES ('2', 'بنك القطيبي', '12102212880341', 'YR', '1');

DROP TABLE IF EXISTS `cash_boxes`;
CREATE TABLE `cash_boxes` (
  `cashbox_id` int(11) NOT NULL AUTO_INCREMENT,
  `cashbox_name` varchar(100) NOT NULL,
  `cashbox_code` varchar(50) DEFAULT NULL,
  `currency_id` int(11) NOT NULL,
  `opening_balance` decimal(15,2) NOT NULL DEFAULT 0.00,
  `current_balance` decimal(15,2) NOT NULL DEFAULT 0.00,
  `status` enum('active','inactive') NOT NULL DEFAULT 'active',
  `notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`cashbox_id`),
  UNIQUE KEY `cashbox_code` (`cashbox_code`),
  KEY `fk_cashbox_currency` (`currency_id`),
  CONSTRAINT `fk_cashbox_currency` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`currency_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `cash_boxes` VALUES ('1', 'Dollar cash', '$$', '1', '0.00', '500.00', 'active', NULL, '2026-01-02 17:24:41', '2026-01-03 22:07:14');

DROP TABLE IF EXISTS `company_settings`;
CREATE TABLE `company_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_name_en` varchar(255) DEFAULT NULL,
  `company_name_ar` varchar(255) DEFAULT NULL,
  `address_en` text DEFAULT NULL,
  `address_ar` text DEFAULT NULL,
  `phones_en` varchar(255) DEFAULT NULL,
  `phones_ar` varchar(255) DEFAULT NULL,
  `logo_path` varchar(255) DEFAULT NULL,
  `footer_text_ar` text DEFAULT NULL,
  `footer_text_en` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
INSERT INTO `company_settings` VALUES ('1', 'Al-Hasnani for Customs Clearance', 'الحصناني للتخليص الجمركي', 'Aden - Free Zone', 'عدن - المنطقة الحرة', '733329970 - 772118152', '773329270 - 771234131', 'logo.png', 'العنوان: بيت بوس - جوار جسر بيت بوس - عمارة المعهد الدور السادس', NULL);

DROP TABLE IF EXISTS `container_types`;
CREATE TABLE `container_types` (
  `container_id` int(11) NOT NULL AUTO_INCREMENT,
  `container_type` varchar(50) NOT NULL COMMENT 'مثال: 20ft, 40ft HC',
  `description` varchar(255) DEFAULT NULL,
  `status` enum('active','inactive') DEFAULT 'active',
  PRIMARY KEY (`container_id`),
  UNIQUE KEY `container_type` (`container_type`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
INSERT INTO `container_types` VALUES ('1', '20ft Standard', 'حاوية نمطية طول 20 قدم', 'active');
INSERT INTO `container_types` VALUES ('2', '40ft Standard', 'حاوية نمطية طول 40 قدم', 'active');
INSERT INTO `container_types` VALUES ('3', '40ft High Cube (HC)', 'حاوية 40 قدم بارتفاع إضافي', 'active');
INSERT INTO `container_types` VALUES ('4', '20ft Reefer', 'حاوية مبردة 20 قدم', 'active');
INSERT INTO `container_types` VALUES ('5', '40ft Reefer', 'حاوية مبردة 40 قدم', 'active');
INSERT INTO `container_types` VALUES ('6', 'Flat Rack', 'حاوية للمعدات الثقيلة', 'active');

DROP TABLE IF EXISTS `currencies`;
CREATE TABLE `currencies` (
  `currency_id` int(11) NOT NULL AUTO_INCREMENT,
  `currency_name` varchar(50) DEFAULT NULL,
  `currency_code` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`currency_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `currencies` VALUES ('1', 'USD', 'USD');

DROP TABLE IF EXISTS `customer_transactions`;
CREATE TABLE `customer_transactions` (
  `trans_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` int(10) unsigned NOT NULL COMMENT 'رقم العميل',
  `debit` decimal(14,2) DEFAULT 0.00 COMMENT 'عليه',
  `credit` decimal(14,2) DEFAULT 0.00 COMMENT 'له',
  `trans_date` date NOT NULL COMMENT 'تاريخ الحركة',
  `description` varchar(255) DEFAULT NULL COMMENT 'البيان',
  `user_id` int(10) unsigned NOT NULL COMMENT 'رقم المستخدم',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`trans_id`),
  KEY `customer_id` (`customer_id`),
  KEY `trans_date` (`trans_date`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `customer_transactions` VALUES ('19', '3', '2000.00', '0.00', '2026-01-03', 'B/L: 99953729071 | Item: Goo1 | Shipment ID: 10', '1', '2026-01-03 06:22:46');
INSERT INTO `customer_transactions` VALUES ('20', '3', '0.00', '500.00', '2026-01-03', 'Pay 500 ', '1', '2026-01-03 06:28:40');
INSERT INTO `customer_transactions` VALUES ('22', '3', '0.00', '100.00', '2026-01-03', 'Payment Received - Voucher #20', '1', '2026-01-03 07:07:16');
INSERT INTO `customer_transactions` VALUES ('23', '3', '0.00', '100.00', '2026-01-03', 'Payment Received - Voucher #21', '1', '2026-01-03 07:11:15');
INSERT INTO `customer_transactions` VALUES ('24', '3', '100.00', '0.00', '2026-01-03', 'إلغاء سند قبض رقم #21 - Reverse Entry', '1', '2026-01-03 08:36:12');
INSERT INTO `customer_transactions` VALUES ('25', '3', '100.00', '0.00', '2026-01-03', 'Reverse: Cancellation of Receipt Voucher #20', '1', '2026-01-03 08:41:26');
INSERT INTO `customer_transactions` VALUES ('26', '3', '0.00', '100.00', '2026-01-03', 'Payment Received - Voucher #22', '1', '2026-01-03 09:05:52');
INSERT INTO `customer_transactions` VALUES ('27', '3', '100.00', '0.00', '2026-01-03', 'Reverse: Cancellation of Receipt Voucher #22', '1', '2026-01-03 09:05:58');
INSERT INTO `customer_transactions` VALUES ('28', '3', '0.00', '100.00', '2026-01-03', 'Payment Received - Voucher #23', '1', '2026-01-03 09:11:15');
INSERT INTO `customer_transactions` VALUES ('29', '3', '0.00', '150.00', '2026-01-03', 'Payment Received - Voucher #24', '1', '2026-01-03 09:12:03');
INSERT INTO `customer_transactions` VALUES ('30', '3', '0.00', '150.00', '2026-01-03', 'Payment Received - Voucher #25 (1)', '1', '2026-01-03 09:13:56');
INSERT INTO `customer_transactions` VALUES ('31', '4', '2000.00', '0.00', '2026-01-03', 'B/L: 99953729071 | Item: شاحنة بضاعة من نوع البلاستيك  | Shipment ID: 11', '1', '2026-01-03 17:51:08');
INSERT INTO `customer_transactions` VALUES ('32', '4', '200.00', '0.00', '2026-01-03', 'B/L: 777sds55454 | Item:  | Shipment ID: 12', '1', '2026-01-03 20:50:12');
INSERT INTO `customer_transactions` VALUES ('33', '5', '1000.00', '0.00', '2026-01-03', 'B/L: 777sds55454555 | Item:  | Shipment ID: 13', '1', '2026-01-03 21:08:00');
INSERT INTO `customer_transactions` VALUES ('34', '3', '0.00', '100.00', '2026-01-03', 'Payment Received - Voucher #26 (اااا)', '1', '2026-01-03 21:37:25');
INSERT INTO `customer_transactions` VALUES ('35', '4', '0.00', '200.00', '2026-01-03', 'CANCELLED: Shipment ID: 12 | B/L: 777sds55454', '1', '2026-01-03 21:48:42');
INSERT INTO `customer_transactions` VALUES ('36', '3', '0.00', '100.00', '2026-01-03', 'Payment Received - Voucher #27 (ااا)', '1', '2026-01-03 22:02:46');
INSERT INTO `customer_transactions` VALUES ('37', '3', '100.00', '0.00', '2026-01-03', 'Reverse: Cancellation of Receipt Voucher #26', '1', '2026-01-03 22:02:50');

DROP TABLE IF EXISTS `customers`;
CREATE TABLE `customers` (
  `customer_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `email` varchar(150) DEFAULT NULL,
  `image` varchar(255) DEFAULT 'default.png',
  `whatsapp` varchar(30) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `status` enum('active','inactive') DEFAULT 'active',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`customer_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `customers` VALUES ('3', 'Almontab', '⁦+966 50 992 4781⁩', 'Alaa@gmail.com', '1767250990_69561c2e9ecd0.jpg', '7887777', 'مصر', '', 'active', '2026-01-01 10:03:10', '2026-01-03 06:21:34');
INSERT INTO `customers` VALUES ('4', 'Alaa', '⁦+966 50 992 4781⁩', 'Alaa@gmail.com', NULL, '7887777', 'Sanaa', '', 'active', '2026-01-02 09:52:23', NULL);
INSERT INTO `customers` VALUES ('5', 'Ali', '733250727', '', NULL, '777777777', '', '', 'active', '2026-01-03 20:47:20', NULL);

DROP TABLE IF EXISTS `daily_transactions`;
CREATE TABLE `daily_transactions` (
  `daily_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `trans_type` enum('customer','agent','cash','expense') NOT NULL COMMENT 'نوع الحركة',
  `ref_id` int(10) unsigned NOT NULL COMMENT 'رقم العميل أو الوكيل أو المصروف',
  `debit` decimal(14,2) DEFAULT 0.00 COMMENT 'عليه',
  `credit` decimal(14,2) DEFAULT 0.00 COMMENT 'له',
  `description` varchar(255) DEFAULT NULL COMMENT 'البيان',
  `trans_date` date NOT NULL COMMENT 'تاريخ الحركة',
  `user_id` int(10) unsigned NOT NULL COMMENT 'رقم المستخدم',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`daily_id`),
  KEY `trans_type` (`trans_type`),
  KEY `ref_id` (`ref_id`),
  KEY `trans_date` (`trans_date`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=57 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `daily_transactions` VALUES ('45', 'customer', '4', '200.00', '0.00', 'B/L: 777sds55454 | Item:  | Shipment ID: 12', '2026-01-03', '1', '2026-01-03 20:50:12');
INSERT INTO `daily_transactions` VALUES ('46', 'agent', '2', '0.00', '100.00', 'B/L: 777sds55454 | Containers: 2 | Shipment ID: 12', '2026-01-03', '1', '2026-01-03 20:50:12');
INSERT INTO `daily_transactions` VALUES ('47', 'customer', '5', '1000.00', '0.00', 'B/L: 777sds55454555 | Item:  | Shipment ID: 13', '2026-01-03', '1', '2026-01-03 21:08:00');
INSERT INTO `daily_transactions` VALUES ('48', 'agent', '1', '0.00', '800.00', 'B/L: 777sds55454555 | Containers: 1 | Shipment ID: 13', '2026-01-03', '1', '2026-01-03 21:08:00');
INSERT INTO `daily_transactions` VALUES ('49', 'customer', '3', '0.00', '100.00', 'Receipt Voucher #26 - اااا', '2026-01-03', '1', '2026-01-03 21:37:25');
INSERT INTO `daily_transactions` VALUES ('50', 'agent', '2', '100.00', '0.00', 'Payment Voucher #1001 - Agent Payment - تتا', '2026-01-03', '1', '2026-01-03 21:37:50');
INSERT INTO `daily_transactions` VALUES ('51', 'customer', '4', '0.00', '200.00', 'CANCELLED: Shipment ID: 12 | B/L: 777sds55454', '2026-01-03', '1', '2026-01-03 21:48:42');
INSERT INTO `daily_transactions` VALUES ('52', 'agent', '2', '100.00', '0.00', 'CANCELLED: Shipment ID: 12 | B/L: 777sds55454', '2026-01-03', '1', '2026-01-03 21:48:42');
INSERT INTO `daily_transactions` VALUES ('53', 'customer', '3', '0.00', '100.00', 'Receipt Voucher #27 - ااا', '2026-01-03', '1', '2026-01-03 22:02:46');
INSERT INTO `daily_transactions` VALUES ('54', 'customer', '3', '100.00', '0.00', 'إلغاء سند قبض رقم #26', '2026-01-03', '1', '2026-01-03 22:02:50');
INSERT INTO `daily_transactions` VALUES ('55', 'agent', '1', '100.00', '0.00', 'Payment Voucher #1002 - Agent Payment - ااا', '2026-01-03', '1', '2026-01-03 22:07:14');
INSERT INTO `daily_transactions` VALUES ('56', '', '2', '0.00', '100.00', 'Voiding Payment #1001', '2026-01-03', '1', '2026-01-03 22:07:18');

DROP TABLE IF EXISTS `expense_transactions`;
CREATE TABLE `expense_transactions` (
  `trans_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `expense_id` int(10) unsigned NOT NULL COMMENT 'رقم المصروف',
  `amount` decimal(14,2) NOT NULL COMMENT 'المبلغ',
  `trans_date` date NOT NULL COMMENT 'تاريخ الحركة',
  `description` varchar(255) DEFAULT NULL COMMENT 'البيان',
  `user_id` int(10) unsigned NOT NULL COMMENT 'رقم المستخدم',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`trans_id`),
  KEY `expense_id` (`expense_id`),
  KEY `trans_date` (`trans_date`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `expenses`;
CREATE TABLE `expenses` (
  `expense_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `expense_name` varchar(150) NOT NULL COMMENT 'اسم المصروف',
  `description` varchar(255) DEFAULT NULL COMMENT 'وصف المصروف',
  `status` enum('active','inactive') DEFAULT 'active',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`expense_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `newshipments`;
CREATE TABLE `newshipments` (
  `shipment_id` int(11) NOT NULL AUTO_INCREMENT,
  `booking_date` date NOT NULL COMMENT 'تاريخ الحجز',
  `order_type` varchar(50) DEFAULT 'استيراد',
  `departure_date` date DEFAULT NULL COMMENT 'تاريخ المغادرة الفعلي',
  `expected_arrival_date` date DEFAULT NULL COMMENT 'تاريخ الوصول المتوقع',
  `customer_id` int(11) NOT NULL COMMENT 'العميل من جدول customers',
  `agent_id` int(11) NOT NULL COMMENT 'الوكيل من جدول agents',
  `currency_id` int(11) NOT NULL COMMENT 'العملة من جدول currencies',
  `source_hub_id` int(11) NOT NULL COMMENT 'ميناء المغادرة من جدول transport_hubs',
  `destination_hub_id` int(11) NOT NULL COMMENT 'ميناء الوصول من جدول transport_hubs',
  `container_type_id` int(11) NOT NULL COMMENT 'نوع الحاوية من جدول container_types',
  `shipment_type` enum('Port to Port','Factory to Port') NOT NULL COMMENT 'نوع الشحن: من الميناء أو المصنع',
  `factory_address` text DEFAULT NULL,
  `shipping_line` varchar(100) NOT NULL COMMENT 'الخط الملاحي (من الجدول أو يدوي)',
  `bill_of_lading` varchar(50) DEFAULT NULL COMMENT 'رقم بوليصة الشحن',
  `item_description` text NOT NULL COMMENT 'وصف البضاعة',
  `shipment_details` text DEFAULT NULL COMMENT 'تفاصيل إضافية للشحن',
  `container_count` int(11) DEFAULT 1 COMMENT 'عدد الحاويات',
  `price_per_container` decimal(15,2) DEFAULT 0.00 COMMENT 'سعر الحاوية الواحدة للعميل',
  `agent_cost` decimal(15,2) DEFAULT 0.00 COMMENT 'سعر التكلفة من الوكيل',
  `grand_total` decimal(15,2) DEFAULT 0.00 COMMENT 'الإجمالي (سعر الحاوية * العدد)',
  `status` enum('inactive','Draft','Booked','In Transit','Arrived','Delivered','Cancelled') DEFAULT 'Booked',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`shipment_id`),
  KEY `customer_id` (`customer_id`),
  KEY `agent_id` (`agent_id`),
  KEY `currency_id` (`currency_id`),
  KEY `source_hub_id` (`source_hub_id`),
  KEY `destination_hub_id` (`destination_hub_id`),
  KEY `container_type_id` (`container_type_id`),
  CONSTRAINT `newshipments_ibfk_1` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`customer_id`),
  CONSTRAINT `newshipments_ibfk_2` FOREIGN KEY (`agent_id`) REFERENCES `agents` (`agent_id`),
  CONSTRAINT `newshipments_ibfk_3` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`currency_id`),
  CONSTRAINT `newshipments_ibfk_4` FOREIGN KEY (`source_hub_id`) REFERENCES `transport_hubs` (`hub_id`),
  CONSTRAINT `newshipments_ibfk_5` FOREIGN KEY (`destination_hub_id`) REFERENCES `transport_hubs` (`hub_id`),
  CONSTRAINT `newshipments_ibfk_6` FOREIGN KEY (`container_type_id`) REFERENCES `container_types` (`container_id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `newshipments` VALUES ('12', '2026-01-03', 'Goods', '2026-01-16', '2026-01-27', '4', '2', '1', '1', '1', '1', 'Port to Port', '', 'Maersk Line', '777sds55454', '', '', '2', '100.00', '100.00', '200.00', 'inactive', '2026-01-03 20:50:12');
INSERT INTO `newshipments` VALUES ('13', '2026-01-03', 'Goods 222', '2026-01-02', '2026-01-21', '5', '1', '1', '1', '4', '1', 'Port to Port', 'hjj', 'MSC (Mediterranean Shipping Company)', '777sds55454555', 'AAA', 'AAA', '1', '1000.00', '800.00', '1000.00', '', '2026-01-03 21:08:00');

DROP TABLE IF EXISTS `operation_logs`;
CREATE TABLE `operation_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `table_name` varchar(100) NOT NULL,
  `record_id` bigint(20) unsigned NOT NULL,
  `action_type` enum('create','update','delete','status_change','print') NOT NULL,
  `field_name` varchar(100) DEFAULT NULL,
  `old_value` text DEFAULT NULL,
  `new_value` text DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `performed_by` int(10) unsigned NOT NULL,
  `performed_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` varchar(255) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  PRIMARY KEY (`log_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `payment_vouchers`;
CREATE TABLE `payment_vouchers` (
  `payment_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_no` varchar(50) DEFAULT NULL COMMENT 'رقم السند',
  `pay_type` enum('agent','expense') NOT NULL COMMENT 'نوع الصرف',
  `cashbox_id` int(11) DEFAULT NULL,
  `ref_id` int(10) unsigned NOT NULL COMMENT 'رقم الوكيل أو المصروف',
  `amount` decimal(14,2) NOT NULL COMMENT 'المبلغ المصروف',
  `payment_date` date NOT NULL COMMENT 'تاريخ السند',
  `description` varchar(255) DEFAULT NULL COMMENT 'البيان',
  `user_id` int(10) unsigned NOT NULL COMMENT 'رقم المستخدم',
  `status` enum('active','inactive') DEFAULT 'active',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`payment_id`),
  KEY `pay_type` (`pay_type`),
  KEY `ref_id` (`ref_id`),
  KEY `payment_date` (`payment_date`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `payment_vouchers` VALUES ('4', '1001', 'agent', NULL, '2', '100.00', '2026-01-03', 'تتا', '1', 'inactive', '2026-01-03 21:37:50');
INSERT INTO `payment_vouchers` VALUES ('5', '1002', 'agent', NULL, '1', '100.00', '2026-01-03', 'ااا', '1', 'active', '2026-01-03 22:07:14');

DROP TABLE IF EXISTS `permissions`;
CREATE TABLE `permissions` (
  `perm_id` int(11) NOT NULL AUTO_INCREMENT,
  `role_id` int(11) DEFAULT NULL,
  `page_name` varchar(50) DEFAULT NULL,
  `can_view` tinyint(1) DEFAULT 0,
  `can_add` tinyint(1) DEFAULT 0,
  `can_edit` tinyint(1) DEFAULT 0,
  `can_delete` tinyint(1) DEFAULT 0,
  `can_print` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`perm_id`),
  KEY `role_id` (`role_id`),
  CONSTRAINT `permissions_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `roles` (`role_id`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `permissions` VALUES ('4', '3', 'cash_box', '1', '1', '0', '0', '1');
INSERT INTO `permissions` VALUES ('5', '3', 'reports', '1', '0', '0', '0', '1');
INSERT INTO `permissions` VALUES ('11', '1', 'dashboard', '1', '0', '0', '0', '0');
INSERT INTO `permissions` VALUES ('12', '1', 'clients', '1', '1', '1', '1', '1');
INSERT INTO `permissions` VALUES ('13', '1', 'agents', '1', '1', '1', '1', '1');
INSERT INTO `permissions` VALUES ('14', '1', 'shipments', '1', '1', '1', '1', '1');
INSERT INTO `permissions` VALUES ('15', '1', 'cash_box', '1', '1', '1', '1', '1');
INSERT INTO `permissions` VALUES ('16', '1', 'settings', '1', '1', '1', '0', '0');
INSERT INTO `permissions` VALUES ('17', '1', 'users', '1', '1', '1', '1', '0');
INSERT INTO `permissions` VALUES ('18', '1', 'invoice', '1', '1', '1', '1', '1');
INSERT INTO `permissions` VALUES ('19', '1', 'receive', '1', '1', '1', '1', '1');
INSERT INTO `permissions` VALUES ('20', '1', 'account_statement', '1', '1', '1', '1', '1');
INSERT INTO `permissions` VALUES ('22', '1', 'safes', '1', '1', '1', '1', '1');
INSERT INTO `permissions` VALUES ('23', '1', 'currencies', '1', '1', '1', '1', '1');
INSERT INTO `permissions` VALUES ('24', '1', 'permissions', '1', '1', '1', '1', '1');
INSERT INTO `permissions` VALUES ('25', '1', 'roles', '1', '1', '1', '1', '1');
INSERT INTO `permissions` VALUES ('26', '1', 'pay', '1', '1', '1', '1', '1');
INSERT INTO `permissions` VALUES ('27', '1', 'agent_transactions', '1', '1', '1', '1', '1');
INSERT INTO `permissions` VALUES ('28', '1', 'customer_transactions', '1', '1', '1', '1', '1');
INSERT INTO `permissions` VALUES ('29', '1', 'daily_transactions', '1', '1', '1', '1', '1');
INSERT INTO `permissions` VALUES ('30', '1', 'export', '1', '1', '1', '1', '1');
INSERT INTO `permissions` VALUES ('31', '1', 'restore', '1', '1', '1', '1', '1');
INSERT INTO `permissions` VALUES ('32', '1', 'price_offers', '1', '1', '1', '1', '1');
INSERT INTO `permissions` VALUES ('33', '4', 'dashboard', '1', '1', '1', '1', '1');
INSERT INTO `permissions` VALUES ('34', '4', 'clients', '1', '1', '1', '1', '1');
INSERT INTO `permissions` VALUES ('35', '4', 'reports', '1', '0', '0', '0', '1');
INSERT INTO `permissions` VALUES ('36', '2', 'reports', '1', '0', '0', '0', '0');
INSERT INTO `permissions` VALUES ('37', '2', 'dashboard', '1', '0', '0', '0', '0');
INSERT INTO `permissions` VALUES ('38', '2', 'clients', '1', '1', '1', '0', '1');
INSERT INTO `permissions` VALUES ('39', '2', 'agents', '1', '1', '1', '0', '1');
INSERT INTO `permissions` VALUES ('40', '2', 'shipments', '1', '1', '1', '0', '1');
INSERT INTO `permissions` VALUES ('41', '2', 'price_offers', '1', '1', '1', '0', '1');
INSERT INTO `permissions` VALUES ('42', '2', 'invoice', '1', '1', '1', '0', '1');
INSERT INTO `permissions` VALUES ('43', '2', 'receive', '1', '1', '1', '0', '1');
INSERT INTO `permissions` VALUES ('44', '2', 'export', '1', '1', '1', '0', '1');
INSERT INTO `permissions` VALUES ('45', '2', 'cash_box', '1', '1', '0', '0', '1');
INSERT INTO `permissions` VALUES ('46', '2', 'safes', '1', '0', '0', '0', '1');
INSERT INTO `permissions` VALUES ('47', '2', 'agent_transactions', '1', '0', '0', '0', '1');
INSERT INTO `permissions` VALUES ('48', '2', 'customer_transactions', '1', '0', '0', '0', '1');
INSERT INTO `permissions` VALUES ('49', '2', 'daily_transactions', '1', '0', '0', '0', '1');
INSERT INTO `permissions` VALUES ('50', '2', 'account_statement', '1', '0', '0', '0', '1');
INSERT INTO `permissions` VALUES ('51', '2', 'reports', '1', '0', '0', '0', '1');
INSERT INTO `permissions` VALUES ('52', '2', 'currencies', '1', '0', '0', '0', '0');
INSERT INTO `permissions` VALUES ('53', '3', 'dashboard', '1', '0', '0', '0', '0');
INSERT INTO `permissions` VALUES ('54', '3', 'clients', '1', '1', '0', '0', '0');
INSERT INTO `permissions` VALUES ('55', '3', 'agents', '1', '1', '0', '0', '0');
INSERT INTO `permissions` VALUES ('56', '3', 'price_offers', '1', '1', '1', '0', '1');
INSERT INTO `permissions` VALUES ('57', '3', 'shipments', '1', '1', '0', '0', '1');
INSERT INTO `permissions` VALUES ('58', '3', 'invoice', '1', '0', '0', '0', '1');
INSERT INTO `permissions` VALUES ('59', '3', 'reports', '1', '0', '0', '0', '1');
INSERT INTO `permissions` VALUES ('60', '3', 'cash_box', '1', '1', '0', '0', '1');
INSERT INTO `permissions` VALUES ('61', '3', 'receive', '1', '1', '0', '0', '0');
INSERT INTO `permissions` VALUES ('62', '3', 'export', '1', '1', '0', '0', '0');
INSERT INTO `permissions` VALUES ('63', '4', 'dashboard', '1', '0', '0', '0', '0');
INSERT INTO `permissions` VALUES ('64', '4', 'clients', '1', '0', '0', '0', '1');
INSERT INTO `permissions` VALUES ('65', '4', 'agents', '1', '0', '0', '0', '1');
INSERT INTO `permissions` VALUES ('66', '4', 'price_offers', '1', '0', '0', '0', '1');
INSERT INTO `permissions` VALUES ('67', '4', 'shipments', '1', '0', '0', '0', '1');
INSERT INTO `permissions` VALUES ('68', '4', 'invoice', '1', '0', '0', '0', '1');
INSERT INTO `permissions` VALUES ('69', '4', 'reports', '1', '0', '0', '0', '1');
INSERT INTO `permissions` VALUES ('70', '4', 'agent_transactions', '1', '0', '0', '0', '1');
INSERT INTO `permissions` VALUES ('71', '4', 'customer_transactions', '1', '0', '0', '0', '1');
INSERT INTO `permissions` VALUES ('72', '4', 'daily_transactions', '1', '0', '0', '0', '1');
INSERT INTO `permissions` VALUES ('73', '4', 'account_statement', '1', '0', '0', '0', '1');
INSERT INTO `permissions` VALUES ('74', '1', 'profile', '1', '1', '1', '1', '1');
INSERT INTO `permissions` VALUES ('75', '4', 'profile', '1', '1', '1', '1', '1');
INSERT INTO `permissions` VALUES ('76', '3', 'profile', '1', '1', '1', '1', '1');
INSERT INTO `permissions` VALUES ('77', '2', 'profile', '1', '1', '1', '1', '1');
INSERT INTO `permissions` VALUES ('78', '4', 'bank_accounts', '1', '1', '1', '1', '1');
INSERT INTO `permissions` VALUES ('79', '3', 'bank_accounts', '1', '1', '1', '0', '1');
INSERT INTO `permissions` VALUES ('80', '1', 'bank_accounts', '1', '1', '1', '1', '1');

DROP TABLE IF EXISTS `price_offers`;
CREATE TABLE `price_offers` (
  `offer_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `offer_date` date NOT NULL,
  `booking_date` date DEFAULT NULL,
  `expected_departure_date` date DEFAULT NULL,
  `expected_arrival_date` date DEFAULT NULL,
  `customer_id` int(10) unsigned NOT NULL,
  `agent_id` int(10) unsigned NOT NULL,
  `currency_id` int(10) unsigned NOT NULL,
  `source_hub_id` int(10) unsigned NOT NULL,
  `destination_hub_id` int(10) unsigned NOT NULL,
  `container_type_id` int(10) unsigned NOT NULL,
  `order_type` varchar(50) NOT NULL,
  `shipment_type` varchar(50) NOT NULL,
  `shipping_line` varchar(100) NOT NULL,
  `bill_of_lading` varchar(100) DEFAULT NULL,
  `factory_address` varchar(255) DEFAULT NULL,
  `item_description` text DEFAULT NULL,
  `shipment_details` text DEFAULT NULL,
  `offer_details` text DEFAULT NULL,
  `container_count` int(10) unsigned NOT NULL DEFAULT 1,
  `price_per_container` decimal(12,2) NOT NULL,
  `agent_cost` decimal(12,2) DEFAULT 0.00,
  `grand_total` decimal(14,2) NOT NULL,
  `status` enum('draft','sent','approved','rejected','expired') DEFAULT 'draft',
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`offer_id`),
  KEY `idx_offer_customer` (`customer_id`),
  KEY `idx_offer_agent` (`agent_id`),
  KEY `idx_offer_status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
INSERT INTO `price_offers` VALUES ('2', '2026-01-03', '2026-01-03', NULL, NULL, '3', '3', '1', '1', '1', '1', 'Goods', 'Factory to Port', '', '777sds55454555', '', '', '', NULL, '1', '0.00', '0.00', '0.00', 'draft', '1', '2026-01-03 21:55:19', NULL);
INSERT INTO `price_offers` VALUES ('3', '2026-01-03', '2026-01-03', NULL, '2026-01-22', '0', '2', '1', '1', '1', '1', 'Goods 222', 'Factory to Port', 'MSC (Mediterranean Shipping Company)', '777sds55454555', 'hjj', '', 'AAA', NULL, '3', '2000.00', '100.00', '6000.00', 'draft', '1', '2026-01-03 21:57:44', NULL);

DROP TABLE IF EXISTS `receipt_vouchers`;
CREATE TABLE `receipt_vouchers` (
  `receipt_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `receipt_no` varchar(50) NOT NULL COMMENT 'رقم سند القبض',
  `customer_id` int(10) unsigned NOT NULL COMMENT 'رقم العميل',
  `amount` decimal(14,2) NOT NULL COMMENT 'مبلغ القبض',
  `cashbox_id` int(11) NOT NULL,
  `currency_id` int(11) DEFAULT NULL,
  `payment_method` varchar(50) DEFAULT NULL,
  `status` enum('active','inactive') NOT NULL DEFAULT 'active',
  `voucher_date` date DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL COMMENT 'رقم المستخدم',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`receipt_id`),
  KEY `receipt_no` (`receipt_no`),
  KEY `customer_id` (`customer_id`),
  KEY `receipt_date` (`voucher_date`),
  KEY `user_id` (`user_id`),
  KEY `fk_voucher_currency` (`currency_id`),
  KEY `fk_voucher_user` (`created_by`),
  KEY `cashbox_id` (`cashbox_id`),
  CONSTRAINT `fk_voucher_currency` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`currency_id`),
  CONSTRAINT `fk_voucher_user` FOREIGN KEY (`created_by`) REFERENCES `users` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `receipt_vouchers` VALUES ('26', '', '3', '100.00', '1', NULL, 'Cash', 'inactive', '2026-01-03', NULL, 'اااا', '1', '2026-01-03 21:37:25');
INSERT INTO `receipt_vouchers` VALUES ('27', '', '3', '100.00', '1', NULL, 'Cash', 'active', '2026-01-03', NULL, 'ااا', '1', '2026-01-03 22:02:46');

DROP TABLE IF EXISTS `roles`;
CREATE TABLE `roles` (
  `role_id` int(11) NOT NULL AUTO_INCREMENT,
  `role_name` varchar(50) NOT NULL,
  PRIMARY KEY (`role_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `roles` VALUES ('1', 'Admin');
INSERT INTO `roles` VALUES ('2', 'Logistical support');
INSERT INTO `roles` VALUES ('3', 'Financial');
INSERT INTO `roles` VALUES ('4', 'Administrative');

DROP TABLE IF EXISTS `shipments`;
CREATE TABLE `shipments` (
  `shipment_id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) DEFAULT NULL,
  `agent_id` int(11) DEFAULT NULL,
  `item_description` text DEFAULT NULL,
  `order_date` date DEFAULT NULL,
  `expected_arrival_date` date DEFAULT NULL,
  `shipping_status` enum('In Country','At Port','In Transit','Arrived','Delivered') DEFAULT 'In Country',
  `customer_total_price` decimal(15,2) DEFAULT NULL,
  `agent_total_cost` decimal(15,2) DEFAULT NULL,
  `currency_id` int(11) DEFAULT NULL,
  `source_hub_id` int(11) DEFAULT NULL,
  `destination_hub_id` int(11) DEFAULT NULL,
  `needs_customs` tinyint(1) DEFAULT 0,
  `is_customs_cleared` tinyint(1) DEFAULT 0,
  `customs_fees` decimal(15,2) DEFAULT 0.00,
  `delivery_fees` decimal(10,2) DEFAULT 0.00,
  `grand_total` decimal(10,2) GENERATED ALWAYS AS (`customer_total_price` + `delivery_fees` + `customs_fees`) VIRTUAL,
  `needs_delivery_to_site` tinyint(1) DEFAULT 0,
  `delivery_address` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`shipment_id`),
  KEY `customer_id` (`customer_id`),
  KEY `agent_id` (`agent_id`),
  KEY `currency_id` (`currency_id`),
  KEY `source_hub_id` (`source_hub_id`),
  KEY `destination_hub_id` (`destination_hub_id`),
  CONSTRAINT `shipments_ibfk_1` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`customer_id`),
  CONSTRAINT `shipments_ibfk_2` FOREIGN KEY (`agent_id`) REFERENCES `agents` (`agent_id`),
  CONSTRAINT `shipments_ibfk_3` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`currency_id`),
  CONSTRAINT `shipments_ibfk_4` FOREIGN KEY (`source_hub_id`) REFERENCES `transport_hubs` (`hub_id`),
  CONSTRAINT `shipments_ibfk_5` FOREIGN KEY (`destination_hub_id`) REFERENCES `transport_hubs` (`hub_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `shipping_lines`;
CREATE TABLE `shipping_lines` (
  `line_id` int(11) NOT NULL AUTO_INCREMENT,
  `line_name` varchar(100) NOT NULL,
  `contact_person` varchar(100) DEFAULT NULL,
  `status` enum('active','inactive') DEFAULT 'active',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`line_id`),
  UNIQUE KEY `line_name` (`line_name`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
INSERT INTO `shipping_lines` VALUES ('1', 'Maersk Line', NULL, 'active', '2026-01-01 13:39:32');
INSERT INTO `shipping_lines` VALUES ('2', 'MSC (Mediterranean Shipping Company)', NULL, 'active', '2026-01-01 13:39:32');
INSERT INTO `shipping_lines` VALUES ('3', 'CMA CGM', NULL, 'active', '2026-01-01 13:39:32');
INSERT INTO `shipping_lines` VALUES ('4', 'COSCO Shipping', NULL, 'active', '2026-01-01 13:39:32');
INSERT INTO `shipping_lines` VALUES ('5', 'Hapag-Lloyd', NULL, 'active', '2026-01-01 13:39:32');
INSERT INTO `shipping_lines` VALUES ('6', 'Evergreen Line', NULL, 'active', '2026-01-01 13:39:32');

DROP TABLE IF EXISTS `transport_hubs`;
CREATE TABLE `transport_hubs` (
  `hub_id` int(11) NOT NULL AUTO_INCREMENT,
  `hub_name` varchar(150) NOT NULL,
  `hub_type` enum('Sea Port','Airport','Land Port') NOT NULL,
  `country` varchar(100) DEFAULT NULL,
  `city` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`hub_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `transport_hubs` VALUES ('1', 'Jeddah Islamic Port', '', 'Saudi Arabia', 'Jeddah');
INSERT INTO `transport_hubs` VALUES ('2', 'Cairo International Airport', 'Airport', 'Egypt', 'Cairo');
INSERT INTO `transport_hubs` VALUES ('4', 'Dubai International Airport', 'Airport', 'United Arab Emirates', 'Dubai');
INSERT INTO `transport_hubs` VALUES ('5', 'Shanghai Port', '', 'China', 'Shanghai');
INSERT INTO `transport_hubs` VALUES ('6', 'Shenzhen Port', '', 'China', 'Shenzhen');
INSERT INTO `transport_hubs` VALUES ('7', 'Ningbo-Zhoushan Port', '', 'China', 'Ningbo');
INSERT INTO `transport_hubs` VALUES ('8', 'Qingdao Port', '', 'China', 'Qingdao');
INSERT INTO `transport_hubs` VALUES ('9', 'Guangzhou Port', '', 'China', 'Guangzhou');
INSERT INTO `transport_hubs` VALUES ('10', 'Tianjin Port', '', 'China', 'Tianjin');

DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `password` varchar(255) NOT NULL,
  `role_id` int(11) DEFAULT NULL,
  `full_name` varchar(100) DEFAULT NULL,
  `status` enum('active','inactive') NOT NULL DEFAULT 'active',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `username` (`username`),
  KEY `role_id` (`role_id`),
  CONSTRAINT `users_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `roles` (`role_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
INSERT INTO `users` VALUES ('1', 'admin', '$2y$10$XyD0YJEBfr36D34uJrxyT.ekykk9e69UTWeIcKSlyafM7r3jons0m', '1', 'Alaa Omar Alqubati', 'active');
INSERT INTO `users` VALUES ('3', 'A', '$2y$10$sE7phXZDYcPQkoWfBNSMm.5z6cSY0bIo3bKoEwkesm2RSlvqvI6S6', '3', NULL, 'active');
INSERT INTO `users` VALUES ('5', 'alaa', '$2y$10$o260YUmp/rUNag.T08iZ1.60DJqJ.sfWKshUzlSQYXZRG/lgX1BZa', '4', 'Alaa alqubati', 'active');
INSERT INTO `users` VALUES ('6', 'admin@example.com', '$2y$10$XFEawA6HA1rm/jn3E2/AOeqz.huCqVL1tQJO2MA512qahZvV3/oH2', '4', 'Alaa alqubati', 'active');

SET FOREIGN_KEY_CHECKS=1;