document.addEventListener('DOMContentLoaded', function() {
    // 1. Hero Slider
    new Swiper('.swiper-container-hero', {
        loop: true,
        speed: 700,
        autoplay: { delay: 3500, disableOnInteraction: false },
        navigation: {
            nextEl: '.swiper-container-hero .swiper-button-next',
            prevEl: '.swiper-container-hero .swiper-button-prev',
        },
        pagination: { el: '.swiper-pagination', clickable: true },
    });

    // 2. Locations Slider
    new Swiper('.swiper-container-locations', {
        slidesPerView: 6,
        spaceBetween: 20,
        navigation: {
            nextEl: '.swiper-container-locations .swiper-button-next',
            prevEl: '.swiper-container-locations .swiper-button-prev',
        },
        breakpoints: {
            0:   { slidesPerView: 2 },
            480: { slidesPerView: 4 },
            768: { slidesPerView: 6 },
        }
    });

    // 3. Services Slider
    new Swiper('.swiper-container-deals', {
        slidesPerView: 3,
        spaceBetween: 20,
        navigation: {
            nextEl: '.swiper-container-deals .swiper-button-next',
            prevEl: '.swiper-container-deals .swiper-button-prev',
        },
        breakpoints: {
            0:   { slidesPerView: 1 },
            600: { slidesPerView: 2 },
            1024:{ slidesPerView: 3 },
        }
    });
});
