(function () {
  const slider = document.getElementById('heroSlider');
  if (!slider) return;

  const slidesWrap = slider.querySelector('.slides');
  const slides = Array.from(slidesWrap.querySelectorAll('.slide'));
  if (!slides.length) return;

  const prevBtn = slider.querySelector('.nav.prev');
  const nextBtn = slider.querySelector('.nav.next');
  const dotsWrap = slider.querySelector('.dots');

  // الإعدادات
  let index = 0;
  let autoplayTimer = null;
  let revealTextTimer = null;
  let revealShadowTimer = null;
  let locked = false;

  // اجعل زمن الانتقال أكبر من 5 ثواني لضمان رؤية النص ثم الظل قبل تغيير السلايد
  const AUTOPLAY_MS = 3000;
  const TRANSITION_LOCK_MS = 700;

  // إنشاء النقاط
  slides.forEach((_, i) => {
    const b = document.createElement('button');
    if (i === 0) b.classList.add('active');
    b.setAttribute('aria-label', `Go to slide ${i + 1}`);
    b.addEventListener('click', () => { goTo(i); startAutoplay(); });
    dotsWrap.appendChild(b);
  });

  function resetReveal(slideEl) {
    if (revealTextTimer)  { clearTimeout(revealTextTimer);  revealTextTimer = null; }
    if (revealShadowTimer){ clearTimeout(revealShadowTimer); revealShadowTimer = null; }
    if (slideEl) slideEl.classList.remove('show-text', 'show-shadow');
  }

 function scheduleReveal(slideEl) {
    // النص بعد 0.5 ثانية (500 مللي ثانية)
    revealTextTimer = setTimeout(() => {
        if (slideEl.classList.contains('active')) {
            slideEl.classList.add('show-text');
        }
    }, 500); // كان 100 مللي ثانية

    // الظل بعد 1 ثانية (500 مللي ثانية بعد النص)
    revealShadowTimer = setTimeout(() => {
        if (slideEl.classList.contains('active')) {
            slideEl.classList.add('show-shadow');
        }
    }, 1000); // كان 500 مللي ثانية
}

  function goTo(i) {
    if (locked) return;
    locked = true;

    // إخفاء الشريحة الحالية
    slides[index].classList.remove('active', 'show-text', 'show-shadow');
    resetReveal(slides[index]);

    // الشريحة الجديدة
    index = (i + slides.length) % slides.length;
    const newSlide = slides[index];
    newSlide.classList.add('active');

    // تحديث النقاط
    dotsWrap.querySelectorAll('button').forEach((d, di) => {
      d.classList.toggle('active', di === index);
    });

    // جدولة: نص ثم ظل
    scheduleReveal(newSlide);

    setTimeout(() => { locked = false; }, TRANSITION_LOCK_MS);
  }

  const next = () => goTo(index + 1);
  const prev = () => goTo(index - 1);

  function startAutoplay() { stopAutoplay(); autoplayTimer = setInterval(next, AUTOPLAY_MS); }
  function stopAutoplay()  { if (autoplayTimer) clearInterval(autoplayTimer); autoplayTimer = null; }

  if (nextBtn) nextBtn.addEventListener('click', () => { next(); startAutoplay(); });
  if (prevBtn) prevBtn.addEventListener('click', () => { prev(); startAutoplay(); });

  slider.addEventListener('mouseenter', stopAutoplay);
  slider.addEventListener('mouseleave', startAutoplay);

  // سحب باللمس
  let startX = 0;
  slider.addEventListener('touchstart', (e) => {
    startX = e.changedTouches[0].clientX;
    stopAutoplay();
  }, { passive: true });
  slider.addEventListener('touchend', (e) => {
    const dx = e.changedTouches[0].clientX - startX;
    if (Math.abs(dx) > 40) (dx < 0 ? next() : prev());
    startAutoplay();
  }, { passive: true });

  // لوحة المفاتيح
  window.addEventListener('keydown', (e) => {
    if (e.key === 'ArrowRight') { next(); startAutoplay(); }
    else if (e.key === 'ArrowLeft') { prev(); startAutoplay(); }
  });

  // تهيئة: بدايةً الصورة فقط (active)، ثم النص والظل بالتوقيت
  slides.forEach(s => s.classList.remove('active', 'show-text', 'show-shadow'));
  slides[0].classList.add('active');
  scheduleReveal(slides[0]);

  startAutoplay();
})();
