// كشف العناصر عند التمرير
(function revealOnScroll(){
  const els = Array.from(document.querySelectorAll('.reveal-up'));
  if (!els.length) return;
  const io = new IntersectionObserver((entries)=>{
    entries.forEach(e=>{
      if (e.isIntersecting){
        e.target.classList.add('reveal-in');
        io.unobserve(e.target);
      }
    });
  }, { threshold: .12, rootMargin: '0px 0px -10% 0px' });
  els.forEach(el=>io.observe(el));
})();

// نسخ سريع عند النقر على الهاتف/البريد (اختياري)
document.addEventListener('click', async (e)=>{
  const a = e.target.closest('.br-link[data-copy]');
  if (!a) return;
  const txt = a.getAttribute('data-copy');
  try {
    await navigator.clipboard.writeText(txt);
    a.classList.add('copied');
    setTimeout(()=> a.classList.remove('copied'), 900);
  } catch(_){}
});

// طيّ/فتح الخريطة داخل البطاقة
document.addEventListener('click', (e)=>{
  const btn = e.target.closest('.br-map-toggle');
  if (!btn) return;

  const card = btn.closest('.br-card');
  const panel = card.querySelector('.br-map-panel');
  if (!panel) return;

  const expanded = btn.getAttribute('aria-expanded') === 'true';
  if (expanded){
    panel.setAttribute('hidden', '');
    btn.setAttribute('aria-expanded', 'false');
    // اختياري: تفريغ src لتقليل استهلاك الموارد
    const iframe = panel.querySelector('iframe');
    if (iframe) iframe.removeAttribute('src');
  } else {
    const embed = btn.getAttribute('data-embed');
    panel.removeAttribute('hidden');
    const iframe = panel.querySelector('iframe');
    if (iframe && embed && !iframe.src){
      iframe.src = embed;
    }
    btn.setAttribute('aria-expanded', 'true');
  }
});
// كشف العناصر عند التمرير
(function revealOnScroll(){
  const els = Array.from(document.querySelectorAll('.reveal-up'));
  if (!els.length) return;
  const io = new IntersectionObserver((entries)=>{
    entries.forEach(e=>{
      if (e.isIntersecting){
        e.target.classList.add('reveal-in');
        io.unobserve(e.target);
      }
    });
  }, { threshold: .12, rootMargin: '0px 0px -10% 0px' });
  els.forEach(el=>io.observe(el));
})();

// نسخ سريع للهاتف/البريد عند النقر (اختياري)
document.addEventListener('click', async (e)=>{
  const a = e.target.closest('.br-link[data-copy]');
  if (!a) return;
  const txt = a.getAttribute('data-copy');
  try {
    await navigator.clipboard.writeText(txt);
    a.classList.add('copied');
    setTimeout(()=> a.classList.remove('copied'), 900);
  } catch(_){}
});
