(function(){
  const section = document.querySelector('#agents');
  if (!section) return;

  const viewport = section.querySelector('.ag-viewport');
  const prevBtn  = section.querySelector('.ag-prev');
  const nextBtn  = section.querySelector('.ag-next');
  if (!viewport || !prevBtn || !nextBtn) return;

  const isRTL = (section.getAttribute('dir') || document.dir || 'ltr').toLowerCase() === 'rtl';

  function stepAmount(){
    // مرّر تقريبًا عرض نافذة العرض ناقص هامش بسيط
    return Math.max(200, Math.floor(viewport.clientWidth * 0.9));
  }

  function scrollByDir(px){
    // في RTL اتّجاه scrollLeft معكوس على متصفحات مختلفة
    const amount = isRTL ? -px : px;
    viewport.scrollBy({ left: amount, behavior: 'smooth' });
  }

  prevBtn.addEventListener('click', ()=> scrollByDir(-stepAmount()));
  nextBtn.addEventListener('click', ()=> scrollByDir(stepAmount()));

  // تشغيل تلقائي (يوقف عند المرور بالماوس أو التركيز)
  let timer = null;
  function start(){
    stop();
    timer = setInterval(()=> scrollByDir(stepAmount()), 3500);
  }
  function stop(){
    if (timer){ clearInterval(timer); timer = null; }
  }
  start();

  ['mouseenter','focusin','touchstart'].forEach(ev => viewport.addEventListener(ev, stop, {passive:true}));
  ['mouseleave','focusout','touchend'].forEach(ev => viewport.addEventListener(ev, start, {passive:true}));

  // تحسين: إذا وصلنا للنهاية، ارجع للبداية بسلاسة
  viewport.addEventListener('scroll', ()=>{
    const maxScroll = viewport.scrollWidth - viewport.clientWidth - 2;
    const nearEnd   = viewport.scrollLeft >= maxScroll;
    const nearStart = viewport.scrollLeft <= 2;
    if (!isRTL && nearEnd) viewport.scrollTo({ left: 0 });
    if (isRTL && nearStart) viewport.scrollTo({ left: viewport.scrollWidth });
  }, { passive:true });
})();
